/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageStreamListFluent<T extends ImageStreamListFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    ImageStreamList.ApiVersion apiVersion;
    List<VisitableBuilder<ImageStream, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ImageStreamList.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(ImageStreamList.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public T addToItems(ImageStream item) {
        if (item != null) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (T)this;
    }

    public List<ImageStream> getItems() {
        return this.build(this.items);
    }

    public T withItems(List<ImageStream> items) {
        this.items.clear();
        if (items != null) {
            for (ImageStream item : items) {
                this.addToItems(item);
            }
        }
        return (T)this;
    }

    public ItemsNested<T> addNewItem() {
        return new ItemsNested();
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ListMetaBuilder builder = new ListMetaBuilder(this);

        @Override
        public N and() {
            return (N)ImageStreamListFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNested<N>
    extends ImageStreamFluent<ItemsNested<N>>
    implements Nested<N> {
        private final ImageStreamBuilder builder = new ImageStreamBuilder(this);

        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageStreamListFluent.this.addToItems(this.builder.build());
        }
    }
}

