/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "clientName", "kind", "metadata", "scopes", "userName", "userUID"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class OAuthClientAuthorization
implements HasMetadata {
    @JsonProperty(value="apiVersion")
    @NotNull
    private ApiVersion apiVersion = ApiVersion.fromValue("v1beta3");
    @JsonProperty(value="clientName")
    private String clientName;
    @JsonProperty(value="kind")
    @NotNull
    private String kind = "OAuthClientAuthorization";
    @JsonProperty(value="metadata")
    @Valid
    private ObjectMeta metadata;
    @JsonProperty(value="scopes")
    @Valid
    private List<String> scopes = new ArrayList<String>();
    @JsonProperty(value="userName")
    private String userName;
    @JsonProperty(value="userUID")
    private String userUID;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public OAuthClientAuthorization() {
    }

    public OAuthClientAuthorization(ApiVersion apiVersion, String clientName, String kind, ObjectMeta metadata, List<String> scopes, String userName, String userUID) {
        this.apiVersion = apiVersion;
        this.clientName = clientName;
        this.kind = kind;
        this.metadata = metadata;
        this.scopes = scopes;
        this.userName = userName;
        this.userUID = userUID;
    }

    @JsonProperty(value="apiVersion")
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="clientName")
    public String getClientName() {
        return this.clientName;
    }

    @JsonProperty(value="clientName")
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="scopes")
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @JsonProperty(value="userUID")
    public String getUserUID() {
        return this.userUID;
    }

    @JsonProperty(value="userUID")
    public void setUserUID(String userUID) {
        this.userUID = userUID;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.apiVersion).append((Object)this.clientName).append((Object)this.kind).append((Object)this.metadata).append(this.scopes).append((Object)this.userName).append((Object)this.userUID).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OAuthClientAuthorization)) {
            return false;
        }
        OAuthClientAuthorization rhs = (OAuthClientAuthorization)other;
        return new EqualsBuilder().append((Object)this.apiVersion, (Object)rhs.apiVersion).append((Object)this.clientName, (Object)rhs.clientName).append((Object)this.kind, (Object)rhs.kind).append((Object)this.metadata, (Object)rhs.metadata).append(this.scopes, rhs.scopes).append((Object)this.userName, (Object)rhs.userName).append((Object)this.userUID, (Object)rhs.userUID).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum ApiVersion {
        V_1_BETA_3("v1beta3"),
        V_1("v1");

        private final String value;
        private static Map<String, ApiVersion> constants;

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiVersion fromValue(String value) {
            ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, ApiVersion>();
            for (ApiVersion c : ApiVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

