/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import io.fabric8.kubernetes.api.model.NodeSystemInfoFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeSystemInfoBuilder
extends NodeSystemInfoFluent<NodeSystemInfoBuilder>
implements VisitableBuilder<NodeSystemInfo, NodeSystemInfoBuilder> {
    NodeSystemInfoFluent<?> fluent;

    public NodeSystemInfoBuilder() {
        this(new NodeSystemInfo());
    }

    public NodeSystemInfoBuilder(NodeSystemInfoFluent<?> fluent) {
        this(fluent, new NodeSystemInfo());
    }

    public NodeSystemInfoBuilder(NodeSystemInfoFluent<?> fluent, NodeSystemInfo instance) {
        this.fluent = fluent;
        fluent.withBootID(instance.getBootID());
        fluent.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
        fluent.withKernelVersion(instance.getKernelVersion());
        fluent.withKubeProxyVersion(instance.getKubeProxyVersion());
        fluent.withKubeletVersion(instance.getKubeletVersion());
        fluent.withMachineID(instance.getMachineID());
        fluent.withOsImage(instance.getOsImage());
        fluent.withSystemUUID(instance.getSystemUUID());
    }

    public NodeSystemInfoBuilder(NodeSystemInfo instance) {
        this.fluent = this;
        this.withBootID(instance.getBootID());
        this.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
        this.withKernelVersion(instance.getKernelVersion());
        this.withKubeProxyVersion(instance.getKubeProxyVersion());
        this.withKubeletVersion(instance.getKubeletVersion());
        this.withMachineID(instance.getMachineID());
        this.withOsImage(instance.getOsImage());
        this.withSystemUUID(instance.getSystemUUID());
    }

    @Override
    public NodeSystemInfo build() {
        NodeSystemInfo buildable = new NodeSystemInfo(this.fluent.getBootID(), this.fluent.getContainerRuntimeVersion(), this.fluent.getKernelVersion(), this.fluent.getKubeProxyVersion(), this.fluent.getKubeletVersion(), this.fluent.getMachineID(), this.fluent.getOsImage(), this.fluent.getSystemUUID());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

