/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.PodStatusBuilder;
import io.fabric8.kubernetes.api.model.PodStatusFluent;
import java.util.HashMap;
import java.util.Map;

public class PodFluent<T extends PodFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Pod.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<PodSpec, ?> spec;
    VisitableBuilder<PodStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Pod.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(Pod.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public PodSpec getSpec() {
        return this.spec != null ? (PodSpec)this.spec.build() : null;
    }

    public T withSpec(PodSpec spec) {
        if (spec != null) {
            this.spec = new PodSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public SpecNested<T> withNewSpecLike(PodSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    public PodStatus getStatus() {
        return this.status != null ? (PodStatus)this.status.build() : null;
    }

    public T withStatus(PodStatus status) {
        if (status != null) {
            this.status = new PodStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    public StatusNested<T> withNewStatus() {
        return new StatusNested();
    }

    public StatusNested<T> withNewStatusLike(PodStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class StatusNested<N>
    extends PodStatusFluent<StatusNested<N>>
    implements Nested<N> {
        private final PodStatusBuilder builder;

        StatusNested(PodStatus item) {
            this.builder = new PodStatusBuilder(this, item);
        }

        StatusNested() {
            this.builder = new PodStatusBuilder(this);
        }

        public N endStatus() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PodFluent.this.withStatus(this.builder.build());
        }
    }

    public class SpecNested<N>
    extends PodSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final PodSpecBuilder builder;

        SpecNested() {
            this.builder = new PodSpecBuilder(this);
        }

        SpecNested(PodSpec item) {
            this.builder = new PodSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PodFluent.this.withMetadata(this.builder.build());
        }
    }
}

