/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildStrategyBuilder
extends BuildStrategyFluent<BuildStrategyBuilder>
implements VisitableBuilder<BuildStrategy, BuildStrategyBuilder> {
    BuildStrategyFluent<?> fluent;

    public BuildStrategyBuilder() {
        this(new BuildStrategy());
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent) {
        this(fluent, new BuildStrategy());
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent, BuildStrategy instance) {
        this.fluent = fluent;
        fluent.withCustomStrategy(instance.getCustomStrategy());
        fluent.withDockerStrategy(instance.getDockerStrategy());
        fluent.withSourceStrategy(instance.getSourceStrategy());
        fluent.withType(instance.getType());
    }

    public BuildStrategyBuilder(BuildStrategy instance) {
        this.fluent = this;
        this.withCustomStrategy(instance.getCustomStrategy());
        this.withDockerStrategy(instance.getDockerStrategy());
        this.withSourceStrategy(instance.getSourceStrategy());
        this.withType(instance.getType());
    }

    @Override
    public BuildStrategy build() {
        BuildStrategy buildable = new BuildStrategy(this.fluent.getCustomStrategy(), this.fluent.getDockerStrategy(), this.fluent.getSourceStrategy(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

