/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.openshift.api.model.WebHookTrigger;
import io.fabric8.openshift.api.model.WebHookTriggerFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class WebHookTriggerBuilder
extends WebHookTriggerFluent<WebHookTriggerBuilder>
implements VisitableBuilder<WebHookTrigger, WebHookTriggerBuilder> {
    WebHookTriggerFluent<?> fluent;

    public WebHookTriggerBuilder() {
        this(new WebHookTrigger());
    }

    public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent) {
        this(fluent, new WebHookTrigger());
    }

    public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent, WebHookTrigger instance) {
        this.fluent = fluent;
        fluent.withSecret(instance.getSecret());
    }

    public WebHookTriggerBuilder(WebHookTrigger instance) {
        this.fluent = this;
        this.withSecret(instance.getSecret());
    }

    @Override
    public WebHookTrigger build() {
        WebHookTrigger buildable = new WebHookTrigger(this.fluent.getSecret());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

