package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NamespaceBuilder extends NamespaceFluent<NamespaceBuilder> implements VisitableBuilder<Namespace,NamespaceBuilder>{
  public NamespaceBuilder() {
    this(new Namespace());
  }
  
  public NamespaceBuilder(NamespaceFluent<?> fluent) {
    this(fluent, new Namespace());
  }
  
  public NamespaceBuilder(NamespaceFluent<?> fluent,Namespace instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NamespaceBuilder(Namespace instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NamespaceFluent<?> fluent;
  
  public Namespace build() {
    Namespace buildable = new Namespace(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}