package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WatchEventBuilder extends WatchEventFluent<WatchEventBuilder> implements VisitableBuilder<WatchEvent,WatchEventBuilder>{
  public WatchEventBuilder() {
    this(new WatchEvent());
  }
  
  public WatchEventBuilder(WatchEventFluent<?> fluent) {
    this(fluent, new WatchEvent());
  }
  
  public WatchEventBuilder(WatchEventFluent<?> fluent,WatchEvent instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WatchEventBuilder(WatchEvent instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WatchEventFluent<?> fluent;
  
  public WatchEvent build() {
    WatchEvent buildable = new WatchEvent(fluent.buildObject(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}