package io.fabric8.kubernetes.api.model.events;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class EventSeriesFluentImpl<A extends EventSeriesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EventSeriesFluent<A>{

    private Integer count;
    private MicroTime lastObservedTime;
    private String state;

    public EventSeriesFluentImpl(){
    }
    public EventSeriesFluentImpl(EventSeries instance){
            this.withCount(instance.getCount()); 
            this.withLastObservedTime(instance.getLastObservedTime()); 
            this.withState(instance.getState()); 
    }

    public Integer getCount(){
            return this.count;
    }

    public A withCount(Integer count){
            this.count=count; return (A) this;
    }

    public Boolean hasCount(){
            return this.count != null;
    }

    public A withNewCount(String arg1){
            return (A)withCount(new Integer(arg1));
    }

    public A withNewCount(int arg1){
            return (A)withCount(new Integer(arg1));
    }

    public MicroTime getLastObservedTime(){
            return this.lastObservedTime;
    }

    public A withLastObservedTime(MicroTime lastObservedTime){
            this.lastObservedTime=lastObservedTime; return (A) this;
    }

    public Boolean hasLastObservedTime(){
            return this.lastObservedTime != null;
    }

    public A withNewLastObservedTime(String time){
            return (A)withLastObservedTime(new MicroTime(time));
    }

    public String getState(){
            return this.state;
    }

    public A withState(String state){
            this.state=state; return (A) this;
    }

    public Boolean hasState(){
            return this.state != null;
    }

    public A withNewState(String arg1){
            return (A)withState(new String(arg1));
    }

    public A withNewState(StringBuilder arg1){
            return (A)withState(new String(arg1));
    }

    public A withNewState(StringBuffer arg1){
            return (A)withState(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            EventSeriesFluentImpl that = (EventSeriesFluentImpl) o;
            if (count != null ? !count.equals(that.count) :that.count != null) return false;
            if (lastObservedTime != null ? !lastObservedTime.equals(that.lastObservedTime) :that.lastObservedTime != null) return false;
            if (state != null ? !state.equals(that.state) :that.state != null) return false;
            return true;
    }




}
