package io.fabric8.kubernetes.api.model.policy;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EvictionBuilder extends EvictionFluentImpl<EvictionBuilder> implements VisitableBuilder<Eviction,EvictionBuilder>{

    EvictionFluent<?> fluent;
    Boolean validationEnabled;

    public EvictionBuilder(){
            this(true);
    }
    public EvictionBuilder(Boolean validationEnabled){
            this(new Eviction(), validationEnabled);
    }
    public EvictionBuilder(EvictionFluent<?> fluent){
            this(fluent, true);
    }
    public EvictionBuilder(EvictionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Eviction(), validationEnabled);
    }
    public EvictionBuilder(EvictionFluent<?> fluent,Eviction instance){
            this(fluent, instance, true);
    }
    public EvictionBuilder(EvictionFluent<?> fluent,Eviction instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withDeleteOptions(instance.getDeleteOptions()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public EvictionBuilder(Eviction instance){
            this(instance,true);
    }
    public EvictionBuilder(Eviction instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withDeleteOptions(instance.getDeleteOptions()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public Eviction build(){
            Eviction buildable = new Eviction(fluent.getApiVersion(),fluent.getDeleteOptions(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EvictionBuilder that = (EvictionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
