package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AllowedCSIDriverBuilder extends AllowedCSIDriverFluentImpl<AllowedCSIDriverBuilder> implements VisitableBuilder<AllowedCSIDriver,AllowedCSIDriverBuilder>{
  public AllowedCSIDriverBuilder() {
    this(false);
  }
  public AllowedCSIDriverBuilder(Boolean validationEnabled) {
    this(new AllowedCSIDriver(), validationEnabled);
  }
  public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent) {
    this(fluent, false);
  }
  public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AllowedCSIDriver(), validationEnabled);
  }
  public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent,AllowedCSIDriver instance) {
    this(fluent, instance, false);
  }
  public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent,AllowedCSIDriver instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AllowedCSIDriverBuilder(AllowedCSIDriver instance) {
    this(instance,false);
  }
  public AllowedCSIDriverBuilder(AllowedCSIDriver instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AllowedCSIDriverFluent<?> fluent;
  Boolean validationEnabled;
  public AllowedCSIDriver build() {
    AllowedCSIDriver buildable = new AllowedCSIDriver(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}