package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IDRangeBuilder extends IDRangeFluentImpl<IDRangeBuilder> implements VisitableBuilder<IDRange,IDRangeBuilder>{
  public IDRangeBuilder() {
    this(false);
  }
  public IDRangeBuilder(Boolean validationEnabled) {
    this(new IDRange(), validationEnabled);
  }
  public IDRangeBuilder(IDRangeFluent<?> fluent) {
    this(fluent, false);
  }
  public IDRangeBuilder(IDRangeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IDRange(), validationEnabled);
  }
  public IDRangeBuilder(IDRangeFluent<?> fluent,IDRange instance) {
    this(fluent, instance, false);
  }
  public IDRangeBuilder(IDRangeFluent<?> fluent,IDRange instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMax(instance.getMax());
      fluent.withMin(instance.getMin());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IDRangeBuilder(IDRange instance) {
    this(instance,false);
  }
  public IDRangeBuilder(IDRange instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMax(instance.getMax());
      this.withMin(instance.getMin());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IDRangeFluent<?> fluent;
  Boolean validationEnabled;
  public IDRange build() {
    IDRange buildable = new IDRange(fluent.getMax(),fluent.getMin());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}