package io.fabric8.openshift.api.model.config.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TokenConfigFluent<A extends TokenConfigFluent<A>> extends BaseFluent<A>{
  public TokenConfigFluent() {
  }
  
  public TokenConfigFluent(TokenConfig instance) {
    this.copyInstance(instance);
  }
  private Duration accessTokenInactivityTimeout;
  private Integer accessTokenInactivityTimeoutSeconds;
  private Integer accessTokenMaxAgeSeconds;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TokenConfig instance) {
    instance = (instance != null ? instance : new TokenConfig());
    if (instance != null) {
          this.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout());
          this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
          this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Duration getAccessTokenInactivityTimeout() {
    return this.accessTokenInactivityTimeout;
  }
  
  public A withAccessTokenInactivityTimeout(Duration accessTokenInactivityTimeout) {
    this.accessTokenInactivityTimeout = accessTokenInactivityTimeout;
    return (A) this;
  }
  
  public boolean hasAccessTokenInactivityTimeout() {
    return this.accessTokenInactivityTimeout != null;
  }
  
  public Integer getAccessTokenInactivityTimeoutSeconds() {
    return this.accessTokenInactivityTimeoutSeconds;
  }
  
  public A withAccessTokenInactivityTimeoutSeconds(Integer accessTokenInactivityTimeoutSeconds) {
    this.accessTokenInactivityTimeoutSeconds = accessTokenInactivityTimeoutSeconds;
    return (A) this;
  }
  
  public boolean hasAccessTokenInactivityTimeoutSeconds() {
    return this.accessTokenInactivityTimeoutSeconds != null;
  }
  
  public Integer getAccessTokenMaxAgeSeconds() {
    return this.accessTokenMaxAgeSeconds;
  }
  
  public A withAccessTokenMaxAgeSeconds(Integer accessTokenMaxAgeSeconds) {
    this.accessTokenMaxAgeSeconds = accessTokenMaxAgeSeconds;
    return (A) this;
  }
  
  public boolean hasAccessTokenMaxAgeSeconds() {
    return this.accessTokenMaxAgeSeconds != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TokenConfigFluent that = (TokenConfigFluent) o;
    if (!java.util.Objects.equals(accessTokenInactivityTimeout, that.accessTokenInactivityTimeout)) return false;
    if (!java.util.Objects.equals(accessTokenInactivityTimeoutSeconds, that.accessTokenInactivityTimeoutSeconds)) return false;
    if (!java.util.Objects.equals(accessTokenMaxAgeSeconds, that.accessTokenMaxAgeSeconds)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(accessTokenInactivityTimeout,  accessTokenInactivityTimeoutSeconds,  accessTokenMaxAgeSeconds,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessTokenInactivityTimeout != null) { sb.append("accessTokenInactivityTimeout:"); sb.append(accessTokenInactivityTimeout + ","); }
    if (accessTokenInactivityTimeoutSeconds != null) { sb.append("accessTokenInactivityTimeoutSeconds:"); sb.append(accessTokenInactivityTimeoutSeconds + ","); }
    if (accessTokenMaxAgeSeconds != null) { sb.append("accessTokenMaxAgeSeconds:"); sb.append(accessTokenMaxAgeSeconds + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}