package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageTagMirrorsBuilder extends ImageTagMirrorsFluent<ImageTagMirrorsBuilder> implements VisitableBuilder<ImageTagMirrors,ImageTagMirrorsBuilder>{
  public ImageTagMirrorsBuilder() {
    this(new ImageTagMirrors());
  }
  
  public ImageTagMirrorsBuilder(ImageTagMirrorsFluent<?> fluent) {
    this(fluent, new ImageTagMirrors());
  }
  
  public ImageTagMirrorsBuilder(ImageTagMirrorsFluent<?> fluent,ImageTagMirrors instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageTagMirrorsBuilder(ImageTagMirrors instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageTagMirrorsFluent<?> fluent;
  
  public ImageTagMirrors build() {
    ImageTagMirrors buildable = new ImageTagMirrors(fluent.getMirrorSourcePolicy(),fluent.getMirrors(),fluent.getSource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}