package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachinePoolStatusBuilder extends MachinePoolStatusFluent<MachinePoolStatusBuilder> implements VisitableBuilder<MachinePoolStatus,MachinePoolStatusBuilder>{
  public MachinePoolStatusBuilder() {
    this(new MachinePoolStatus());
  }
  
  public MachinePoolStatusBuilder(MachinePoolStatusFluent<?> fluent) {
    this(fluent, new MachinePoolStatus());
  }
  
  public MachinePoolStatusBuilder(MachinePoolStatusFluent<?> fluent,MachinePoolStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachinePoolStatusBuilder(MachinePoolStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachinePoolStatusFluent<?> fluent;
  
  public MachinePoolStatus build() {
    MachinePoolStatus buildable = new MachinePoolStatus(fluent.buildConditions(),fluent.buildMachineSets(),fluent.getOwnedLabels(),fluent.buildOwnedTaints(),fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}