package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachinePoolPlatformBuilder extends MachinePoolPlatformFluent<MachinePoolPlatformBuilder> implements VisitableBuilder<MachinePoolPlatform,MachinePoolPlatformBuilder>{
  public MachinePoolPlatformBuilder() {
    this(new MachinePoolPlatform());
  }
  
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent) {
    this(fluent, new MachinePoolPlatform());
  }
  
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,MachinePoolPlatform instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachinePoolPlatformBuilder(MachinePoolPlatform instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachinePoolPlatformFluent<?> fluent;
  
  public MachinePoolPlatform build() {
    MachinePoolPlatform buildable = new MachinePoolPlatform(fluent.getAdditionalSecurityGroupIDs(),fluent.buildMetadataService(),fluent.buildRootVolume(),fluent.buildSpotMarketOptions(),fluent.getSubnets(),fluent.getType(),fluent.getZones());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}