package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DNSCacheBuilder extends DNSCacheFluent<DNSCacheBuilder> implements VisitableBuilder<DNSCache,DNSCacheBuilder>{
  public DNSCacheBuilder() {
    this(new DNSCache());
  }
  
  public DNSCacheBuilder(DNSCacheFluent<?> fluent) {
    this(fluent, new DNSCache());
  }
  
  public DNSCacheBuilder(DNSCacheFluent<?> fluent,DNSCache instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DNSCacheBuilder(DNSCache instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DNSCacheFluent<?> fluent;
  
  public DNSCache build() {
    DNSCache buildable = new DNSCache(fluent.getNegativeTTL(),fluent.getPositiveTTL());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}