package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DNSNodePlacementBuilder extends DNSNodePlacementFluent<DNSNodePlacementBuilder> implements VisitableBuilder<DNSNodePlacement,DNSNodePlacementBuilder>{
  public DNSNodePlacementBuilder() {
    this(new DNSNodePlacement());
  }
  
  public DNSNodePlacementBuilder(DNSNodePlacementFluent<?> fluent) {
    this(fluent, new DNSNodePlacement());
  }
  
  public DNSNodePlacementBuilder(DNSNodePlacementFluent<?> fluent,DNSNodePlacement instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DNSNodePlacementBuilder(DNSNodePlacement instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DNSNodePlacementFluent<?> fluent;
  
  public DNSNodePlacement build() {
    DNSNodePlacement buildable = new DNSNodePlacement(fluent.getNodeSelector(),fluent.getTolerations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}