package io.fabric8.openshift.api.model.operator.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KuryrConfigFluent<A extends KuryrConfigFluent<A>> extends BaseFluent<A>{
  public KuryrConfigFluent() {
  }
  
  public KuryrConfigFluent(KuryrConfig instance) {
    this.copyInstance(instance);
  }
  private Integer controllerProbesPort;
  private Integer daemonProbesPort;
  private Boolean enablePortPoolsPrepopulation;
  private Integer mtu;
  private String openStackServiceNetwork;
  private Integer poolBatchPorts;
  private Integer poolMaxPorts;
  private Integer poolMinPorts;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(KuryrConfig instance) {
    instance = (instance != null ? instance : new KuryrConfig());
    if (instance != null) {
          this.withControllerProbesPort(instance.getControllerProbesPort());
          this.withDaemonProbesPort(instance.getDaemonProbesPort());
          this.withEnablePortPoolsPrepopulation(instance.getEnablePortPoolsPrepopulation());
          this.withMtu(instance.getMtu());
          this.withOpenStackServiceNetwork(instance.getOpenStackServiceNetwork());
          this.withPoolBatchPorts(instance.getPoolBatchPorts());
          this.withPoolMaxPorts(instance.getPoolMaxPorts());
          this.withPoolMinPorts(instance.getPoolMinPorts());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getControllerProbesPort() {
    return this.controllerProbesPort;
  }
  
  public A withControllerProbesPort(Integer controllerProbesPort) {
    this.controllerProbesPort = controllerProbesPort;
    return (A) this;
  }
  
  public boolean hasControllerProbesPort() {
    return this.controllerProbesPort != null;
  }
  
  public Integer getDaemonProbesPort() {
    return this.daemonProbesPort;
  }
  
  public A withDaemonProbesPort(Integer daemonProbesPort) {
    this.daemonProbesPort = daemonProbesPort;
    return (A) this;
  }
  
  public boolean hasDaemonProbesPort() {
    return this.daemonProbesPort != null;
  }
  
  public Boolean getEnablePortPoolsPrepopulation() {
    return this.enablePortPoolsPrepopulation;
  }
  
  public A withEnablePortPoolsPrepopulation(Boolean enablePortPoolsPrepopulation) {
    this.enablePortPoolsPrepopulation = enablePortPoolsPrepopulation;
    return (A) this;
  }
  
  public boolean hasEnablePortPoolsPrepopulation() {
    return this.enablePortPoolsPrepopulation != null;
  }
  
  public Integer getMtu() {
    return this.mtu;
  }
  
  public A withMtu(Integer mtu) {
    this.mtu = mtu;
    return (A) this;
  }
  
  public boolean hasMtu() {
    return this.mtu != null;
  }
  
  public String getOpenStackServiceNetwork() {
    return this.openStackServiceNetwork;
  }
  
  public A withOpenStackServiceNetwork(String openStackServiceNetwork) {
    this.openStackServiceNetwork = openStackServiceNetwork;
    return (A) this;
  }
  
  public boolean hasOpenStackServiceNetwork() {
    return this.openStackServiceNetwork != null;
  }
  
  public Integer getPoolBatchPorts() {
    return this.poolBatchPorts;
  }
  
  public A withPoolBatchPorts(Integer poolBatchPorts) {
    this.poolBatchPorts = poolBatchPorts;
    return (A) this;
  }
  
  public boolean hasPoolBatchPorts() {
    return this.poolBatchPorts != null;
  }
  
  public Integer getPoolMaxPorts() {
    return this.poolMaxPorts;
  }
  
  public A withPoolMaxPorts(Integer poolMaxPorts) {
    this.poolMaxPorts = poolMaxPorts;
    return (A) this;
  }
  
  public boolean hasPoolMaxPorts() {
    return this.poolMaxPorts != null;
  }
  
  public Integer getPoolMinPorts() {
    return this.poolMinPorts;
  }
  
  public A withPoolMinPorts(Integer poolMinPorts) {
    this.poolMinPorts = poolMinPorts;
    return (A) this;
  }
  
  public boolean hasPoolMinPorts() {
    return this.poolMinPorts != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KuryrConfigFluent that = (KuryrConfigFluent) o;
    if (!java.util.Objects.equals(controllerProbesPort, that.controllerProbesPort)) return false;
    if (!java.util.Objects.equals(daemonProbesPort, that.daemonProbesPort)) return false;
    if (!java.util.Objects.equals(enablePortPoolsPrepopulation, that.enablePortPoolsPrepopulation)) return false;
    if (!java.util.Objects.equals(mtu, that.mtu)) return false;
    if (!java.util.Objects.equals(openStackServiceNetwork, that.openStackServiceNetwork)) return false;
    if (!java.util.Objects.equals(poolBatchPorts, that.poolBatchPorts)) return false;
    if (!java.util.Objects.equals(poolMaxPorts, that.poolMaxPorts)) return false;
    if (!java.util.Objects.equals(poolMinPorts, that.poolMinPorts)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(controllerProbesPort,  daemonProbesPort,  enablePortPoolsPrepopulation,  mtu,  openStackServiceNetwork,  poolBatchPorts,  poolMaxPorts,  poolMinPorts,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (controllerProbesPort != null) { sb.append("controllerProbesPort:"); sb.append(controllerProbesPort + ","); }
    if (daemonProbesPort != null) { sb.append("daemonProbesPort:"); sb.append(daemonProbesPort + ","); }
    if (enablePortPoolsPrepopulation != null) { sb.append("enablePortPoolsPrepopulation:"); sb.append(enablePortPoolsPrepopulation + ","); }
    if (mtu != null) { sb.append("mtu:"); sb.append(mtu + ","); }
    if (openStackServiceNetwork != null) { sb.append("openStackServiceNetwork:"); sb.append(openStackServiceNetwork + ","); }
    if (poolBatchPorts != null) { sb.append("poolBatchPorts:"); sb.append(poolBatchPorts + ","); }
    if (poolMaxPorts != null) { sb.append("poolMaxPorts:"); sb.append(poolMaxPorts + ","); }
    if (poolMinPorts != null) { sb.append("poolMinPorts:"); sb.append(poolMinPorts + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEnablePortPoolsPrepopulation() {
    return withEnablePortPoolsPrepopulation(true);
  }
  

}