package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DNSRecordBuilder extends DNSRecordFluent<DNSRecordBuilder> implements VisitableBuilder<DNSRecord,DNSRecordBuilder>{
  public DNSRecordBuilder() {
    this(new DNSRecord());
  }
  
  public DNSRecordBuilder(DNSRecordFluent<?> fluent) {
    this(fluent, new DNSRecord());
  }
  
  public DNSRecordBuilder(DNSRecordFluent<?> fluent,DNSRecord instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DNSRecordBuilder(DNSRecord instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DNSRecordFluent<?> fluent;
  
  public DNSRecord build() {
    DNSRecord buildable = new DNSRecord(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}