package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProxyConfigFluent<A extends ProxyConfigFluent<A>> extends BaseFluent<A>{
  public ProxyConfigFluent() {
  }
  
  public ProxyConfigFluent(ProxyConfig instance) {
    this.copyInstance(instance);
  }
  private String bindAddress;
  private String iptablesSyncPeriod;
  private Map<String,ArrayList<String>> proxyArguments;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ProxyConfig instance) {
    instance = (instance != null ? instance : new ProxyConfig());
    if (instance != null) {
          this.withBindAddress(instance.getBindAddress());
          this.withIptablesSyncPeriod(instance.getIptablesSyncPeriod());
          this.withProxyArguments(instance.getProxyArguments());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBindAddress() {
    return this.bindAddress;
  }
  
  public A withBindAddress(String bindAddress) {
    this.bindAddress = bindAddress;
    return (A) this;
  }
  
  public boolean hasBindAddress() {
    return this.bindAddress != null;
  }
  
  public String getIptablesSyncPeriod() {
    return this.iptablesSyncPeriod;
  }
  
  public A withIptablesSyncPeriod(String iptablesSyncPeriod) {
    this.iptablesSyncPeriod = iptablesSyncPeriod;
    return (A) this;
  }
  
  public boolean hasIptablesSyncPeriod() {
    return this.iptablesSyncPeriod != null;
  }
  
  public A addToProxyArguments(String key,ArrayList<String> value) {
    if(this.proxyArguments == null && key != null && value != null) { this.proxyArguments = new LinkedHashMap(); }
    if(key != null && value != null) {this.proxyArguments.put(key, value);} return (A)this;
  }
  
  public A addToProxyArguments(Map<String,ArrayList<String>> map) {
    if(this.proxyArguments == null && map != null) { this.proxyArguments = new LinkedHashMap(); }
    if(map != null) { this.proxyArguments.putAll(map);} return (A)this;
  }
  
  public A removeFromProxyArguments(String key) {
    if(this.proxyArguments == null) { return (A) this; }
    if(key != null && this.proxyArguments != null) {this.proxyArguments.remove(key);} return (A)this;
  }
  
  public A removeFromProxyArguments(Map<String,ArrayList<String>> map) {
    if(this.proxyArguments == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.proxyArguments != null){this.proxyArguments.remove(key);}}} return (A)this;
  }
  
  public Map<String,ArrayList<String>> getProxyArguments() {
    return this.proxyArguments;
  }
  
  public <K,V>A withProxyArguments(Map<String,ArrayList<String>> proxyArguments) {
    if (proxyArguments == null) {
      this.proxyArguments = null;
    } else {
      this.proxyArguments = new LinkedHashMap(proxyArguments);
    }
    return (A) this;
  }
  
  public boolean hasProxyArguments() {
    return this.proxyArguments != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProxyConfigFluent that = (ProxyConfigFluent) o;
    if (!java.util.Objects.equals(bindAddress, that.bindAddress)) return false;
    if (!java.util.Objects.equals(iptablesSyncPeriod, that.iptablesSyncPeriod)) return false;
    if (!java.util.Objects.equals(proxyArguments, that.proxyArguments)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bindAddress,  iptablesSyncPeriod,  proxyArguments,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bindAddress != null) { sb.append("bindAddress:"); sb.append(bindAddress + ","); }
    if (iptablesSyncPeriod != null) { sb.append("iptablesSyncPeriod:"); sb.append(iptablesSyncPeriod + ","); }
    if (proxyArguments != null && !proxyArguments.isEmpty()) { sb.append("proxyArguments:"); sb.append(proxyArguments + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}