package io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PackageManifestBuilder extends PackageManifestFluent<PackageManifestBuilder> implements VisitableBuilder<PackageManifest,PackageManifestBuilder>{
  public PackageManifestBuilder() {
    this(new PackageManifest());
  }
  
  public PackageManifestBuilder(PackageManifestFluent<?> fluent) {
    this(fluent, new PackageManifest());
  }
  
  public PackageManifestBuilder(PackageManifestFluent<?> fluent,PackageManifest instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PackageManifestBuilder(PackageManifest instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PackageManifestFluent<?> fluent;
  
  public PackageManifest build() {
    PackageManifest buildable = new PackageManifest(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}