package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TunedMatchBuilder extends TunedMatchFluent<TunedMatchBuilder> implements VisitableBuilder<TunedMatch,TunedMatchBuilder>{
  public TunedMatchBuilder() {
    this(new TunedMatch());
  }
  
  public TunedMatchBuilder(TunedMatchFluent<?> fluent) {
    this(fluent, new TunedMatch());
  }
  
  public TunedMatchBuilder(TunedMatchFluent<?> fluent,TunedMatch instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TunedMatchBuilder(TunedMatch instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TunedMatchFluent<?> fluent;
  
  public TunedMatch build() {
    TunedMatch buildable = new TunedMatch(fluent.getLabel(),fluent.buildMatch(),fluent.getType(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}