/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.inversoft.error.Errors;
import com.inversoft.json.JacksonModule;
import com.inversoft.rest.ClientResponse;
import com.inversoft.rest.JSONBodyHandler;
import com.inversoft.rest.JSONResponseHandler;
import com.inversoft.rest.RESTClient;
import io.fusionauth.domain.api.ApplicationRequest;
import io.fusionauth.domain.api.ApplicationResponse;
import io.fusionauth.domain.api.AuditLogRequest;
import io.fusionauth.domain.api.AuditLogResponse;
import io.fusionauth.domain.api.AuditLogSearchRequest;
import io.fusionauth.domain.api.AuditLogSearchResponse;
import io.fusionauth.domain.api.EmailTemplateRequest;
import io.fusionauth.domain.api.EmailTemplateResponse;
import io.fusionauth.domain.api.GroupRequest;
import io.fusionauth.domain.api.GroupResponse;
import io.fusionauth.domain.api.IdentityProviderRequest;
import io.fusionauth.domain.api.IdentityProviderResponse;
import io.fusionauth.domain.api.IntegrationRequest;
import io.fusionauth.domain.api.IntegrationResponse;
import io.fusionauth.domain.api.LoginRequest;
import io.fusionauth.domain.api.LoginResponse;
import io.fusionauth.domain.api.MemberDeleteRequest;
import io.fusionauth.domain.api.MemberRequest;
import io.fusionauth.domain.api.MemberResponse;
import io.fusionauth.domain.api.OAuthConfigurationResponse;
import io.fusionauth.domain.api.PasswordValidationRulesResponse;
import io.fusionauth.domain.api.PreviewRequest;
import io.fusionauth.domain.api.PreviewResponse;
import io.fusionauth.domain.api.PublicKeyResponse;
import io.fusionauth.domain.api.SystemConfigurationRequest;
import io.fusionauth.domain.api.SystemConfigurationResponse;
import io.fusionauth.domain.api.TenantRequest;
import io.fusionauth.domain.api.TenantResponse;
import io.fusionauth.domain.api.TwoFactorRequest;
import io.fusionauth.domain.api.UserActionReasonRequest;
import io.fusionauth.domain.api.UserActionReasonResponse;
import io.fusionauth.domain.api.UserActionRequest;
import io.fusionauth.domain.api.UserActionResponse;
import io.fusionauth.domain.api.UserCommentRequest;
import io.fusionauth.domain.api.UserCommentResponse;
import io.fusionauth.domain.api.UserDeleteRequest;
import io.fusionauth.domain.api.UserRequest;
import io.fusionauth.domain.api.UserResponse;
import io.fusionauth.domain.api.WebhookRequest;
import io.fusionauth.domain.api.WebhookResponse;
import io.fusionauth.domain.api.email.SendRequest;
import io.fusionauth.domain.api.email.SendResponse;
import io.fusionauth.domain.api.identityProvider.LookupResponse;
import io.fusionauth.domain.api.jwt.IssueResponse;
import io.fusionauth.domain.api.jwt.ReconcileRequest;
import io.fusionauth.domain.api.jwt.RefreshRequest;
import io.fusionauth.domain.api.jwt.RefreshResponse;
import io.fusionauth.domain.api.jwt.ValidateResponse;
import io.fusionauth.domain.api.report.DailyActiveUserReportResponse;
import io.fusionauth.domain.api.report.LoginReportResponse;
import io.fusionauth.domain.api.report.MonthlyActiveUserReportResponse;
import io.fusionauth.domain.api.report.RegistrationReportResponse;
import io.fusionauth.domain.api.report.TotalsReportResponse;
import io.fusionauth.domain.api.report.UserLoginReportResponse;
import io.fusionauth.domain.api.twoFactor.SecretResponse;
import io.fusionauth.domain.api.twoFactor.TwoFactorLoginRequest;
import io.fusionauth.domain.api.twoFactor.TwoFactorSendRequest;
import io.fusionauth.domain.api.user.ActionRequest;
import io.fusionauth.domain.api.user.ActionResponse;
import io.fusionauth.domain.api.user.ChangePasswordRequest;
import io.fusionauth.domain.api.user.ForgotPasswordRequest;
import io.fusionauth.domain.api.user.ForgotPasswordResponse;
import io.fusionauth.domain.api.user.ImportRequest;
import io.fusionauth.domain.api.user.RegistrationRequest;
import io.fusionauth.domain.api.user.RegistrationResponse;
import io.fusionauth.domain.api.user.SearchRequest;
import io.fusionauth.domain.api.user.SearchResponse;
import io.fusionauth.domain.api.user.VerifyEmailResponse;
import io.fusionauth.domain.api.user.VerifyRegistrationResponse;
import java.util.Collection;
import java.util.UUID;

public class FusionAuthClient {
    public static String TENANT_ID_HEADER = "X-FusionAuth-TenantId";
    public static final ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false).configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JacksonModule());
    private final String apiKey;
    private final String baseURL;
    private final String tenantId;
    public int connectTimeout = 2000;
    public int readTimeout = 2000;

    public FusionAuthClient(String apiKey, String baseURL) {
        this(apiKey, baseURL, null);
    }

    public FusionAuthClient(String apiKey, String baseURL, String tenantId) {
        this(apiKey, baseURL, 2000, 2000, tenantId);
    }

    public FusionAuthClient(String apiKey, String baseURL, int connectTimeout, int readTimeout) {
        this(apiKey, baseURL, connectTimeout, readTimeout, null);
    }

    public FusionAuthClient(String apiKey, String baseURL, int connectTimeout, int readTimeout, String tenantId) {
        this.apiKey = apiKey;
        this.baseURL = baseURL;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.tenantId = tenantId;
    }

    public FusionAuthClient setTenantId(UUID tenantId) {
        if (tenantId == null) {
            return this;
        }
        return new FusionAuthClient(this.apiKey, this.baseURL, this.connectTimeout, this.readTimeout, tenantId.toString());
    }

    public ClientResponse<ActionResponse, Errors> actionUser(UUID actioneeUserId, ActionRequest request) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").urlSegment((Object)actioneeUserId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<ActionResponse, Errors> cancelAction(UUID actionId, ActionRequest request) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").urlSegment((Object)actionId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).delete().go();
    }

    public ClientResponse<Void, Errors> changePassword(String changePasswordId, ChangePasswordRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/change-password").urlSegment((Object)changePasswordId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<Void, Errors> changePasswordByIdentity(ChangePasswordRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/change-password").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<Void, Errors> commentOnUser(UserCommentRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/comment").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<ApplicationResponse, Errors> createApplication(UUID applicationId, ApplicationRequest request) {
        return this.start(ApplicationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<ApplicationResponse, Errors> createApplicationRole(UUID applicationId, UUID roleId, ApplicationRequest request) {
        return this.start(ApplicationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"role").urlSegment((Object)roleId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<AuditLogResponse, Errors> createAuditLog(AuditLogRequest request) {
        return this.start(AuditLogResponse.class, Errors.class).uri("/api/system/audit-log").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<EmailTemplateResponse, Errors> createEmailTemplate(UUID emailTemplateId, EmailTemplateRequest request) {
        return this.start(EmailTemplateResponse.class, Errors.class).uri("/api/email/template").urlSegment((Object)emailTemplateId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<GroupResponse, Errors> createGroup(UUID groupId, GroupRequest request) {
        return this.start(GroupResponse.class, Errors.class).uri("/api/group").urlSegment((Object)groupId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<MemberResponse, Errors> createGroupMembers(MemberRequest request) {
        return this.start(MemberResponse.class, Errors.class).uri("/api/group/member").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<IdentityProviderResponse, Errors> createIdentityProvider(UUID identityProviderId, IdentityProviderRequest request) {
        return this.start(IdentityProviderResponse.class, Errors.class).uri("/api/identity-provider").urlSegment((Object)identityProviderId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<TenantResponse, Errors> createTenant(UUID tenantId, TenantRequest request) {
        return this.start(TenantResponse.class, Errors.class).uri("/api/tenant").urlSegment((Object)tenantId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<UserResponse, Errors> createUser(UUID userId, UserRequest request) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<UserActionResponse, Errors> createUserAction(UUID userActionId, UserActionRequest request) {
        return this.start(UserActionResponse.class, Errors.class).uri("/api/user-action").urlSegment((Object)userActionId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<UserActionReasonResponse, Errors> createUserActionReason(UUID userActionReasonId, UserActionReasonRequest request) {
        return this.start(UserActionReasonResponse.class, Errors.class).uri("/api/user-action-reason").urlSegment((Object)userActionReasonId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<WebhookResponse, Errors> createWebhook(UUID webhookId, WebhookRequest request) {
        return this.start(WebhookResponse.class, Errors.class).uri("/api/webhook").urlSegment((Object)webhookId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<Void, Errors> deactivateApplication(UUID applicationId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/application").urlSegment((Object)applicationId).delete().go();
    }

    public ClientResponse<Void, Errors> deactivateUser(UUID userId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user").urlSegment((Object)userId).delete().go();
    }

    public ClientResponse<Void, Errors> deactivateUserAction(UUID userActionId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user-action").urlSegment((Object)userActionId).delete().go();
    }

    public ClientResponse<Void, Errors> deactivateUsers(Collection<UUID> userIds) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/bulk").urlParameter("userId", userIds).delete().go();
    }

    public ClientResponse<Void, Errors> deleteApplication(UUID applicationId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlParameter("hardDelete", (Object)true).delete().go();
    }

    public ClientResponse<Void, Errors> deleteApplicationRole(UUID applicationId, UUID roleId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"role").urlSegment((Object)roleId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteEmailTemplate(UUID emailTemplateId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/email/template").urlSegment((Object)emailTemplateId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteGroup(UUID groupId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/group").urlSegment((Object)groupId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteGroupMembers(MemberDeleteRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/group/member").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).delete().go();
    }

    public ClientResponse<Void, Errors> deleteIdentityProvider(UUID identityProviderId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/identity-provider").urlSegment((Object)identityProviderId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteRegistration(UUID userId, UUID applicationId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/registration").urlSegment((Object)userId).urlSegment((Object)applicationId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteTenant(UUID tenantId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/tenant").urlSegment((Object)tenantId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteUser(UUID userId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user").urlSegment((Object)userId).urlParameter("hardDelete", (Object)true).delete().go();
    }

    public ClientResponse<Void, Errors> deleteUserAction(UUID userActionId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user-action").urlSegment((Object)userActionId).urlParameter("hardDelete", (Object)true).delete().go();
    }

    public ClientResponse<Void, Errors> deleteUserActionReason(UUID userActionReasonId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user-action-reason").urlSegment((Object)userActionReasonId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteUsers(UserDeleteRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/bulk").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).delete().go();
    }

    public ClientResponse<Void, Errors> deleteWebhook(UUID webhookId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/webhook").urlSegment((Object)webhookId).delete().go();
    }

    public ClientResponse<Void, Errors> disableTwoFactor(UUID userId, String code) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/two-factor").urlParameter("userId", (Object)userId).urlParameter("code", (Object)code).delete().go();
    }

    public ClientResponse<Void, Errors> enableTwoFactor(UUID userId, TwoFactorRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/two-factor").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<RefreshResponse, Errors> exchangeRefreshTokenForJWT(RefreshRequest request) {
        return this.start(RefreshResponse.class, Errors.class).uri("/api/jwt/refresh").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<ForgotPasswordResponse, Errors> forgotPassword(ForgotPasswordRequest request) {
        return this.start(ForgotPasswordResponse.class, Errors.class).uri("/api/user/forgot-password").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<VerifyEmailResponse, Void> generateEmailVerificationId(String email) {
        return this.start(VerifyEmailResponse.class, Void.TYPE).uri("/api/user/verify-email").urlParameter("email", (Object)email).urlParameter("sendVerifyPasswordEmail", (Object)false).put().go();
    }

    public ClientResponse<VerifyRegistrationResponse, Void> generateRegistrationVerificationId(String email, UUID applicationId) {
        return this.start(VerifyRegistrationResponse.class, Void.TYPE).uri("/api/user/verify-registration").urlParameter("email", (Object)email).urlParameter("sendVerifyPasswordEmail", (Object)false).urlParameter("applicationId", (Object)applicationId).put().go();
    }

    public ClientResponse<SecretResponse, Void> generateTwoFactorSecret() {
        return this.start(SecretResponse.class, Void.TYPE).uri("/api/two-factor/secret").get().go();
    }

    public ClientResponse<SecretResponse, Void> generateTwoFactorSecretUsingJWT(String encodedJWT) {
        return this.start(SecretResponse.class, Void.TYPE).uri("/api/two-factor/secret").authorization("JWT " + encodedJWT).get().go();
    }

    public ClientResponse<Void, Errors> importUsers(ImportRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/import").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<IssueResponse, Errors> issueJWT(UUID applicationId, String encodedJWT) {
        return this.start(IssueResponse.class, Errors.class).uri("/api/jwt/issue").authorization("JWT " + encodedJWT).urlParameter("applicationId", (Object)applicationId).get().go();
    }

    public ClientResponse<LoginResponse, Errors> login(LoginRequest request) {
        return this.start(LoginResponse.class, Errors.class).uri("/api/login").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<Void, Errors> loginPing(UUID userId, UUID applicationId, String callerIPAddress) {
        return this.start(Void.TYPE, Errors.class).uri("/api/login").urlSegment((Object)userId).urlSegment((Object)applicationId).urlParameter("ipAddress", (Object)callerIPAddress).put().go();
    }

    public ClientResponse<Void, Void> logout(boolean global, String refreshToken) {
        return this.start(Void.TYPE, Void.TYPE).uri("/api/logout").urlParameter("global", (Object)global).urlParameter("refreshToken", (Object)refreshToken).post().go();
    }

    public ClientResponse<LookupResponse, Void> lookupIdentityProvider(String domain) {
        return this.start(LookupResponse.class, Void.TYPE).uri("/api/identity-provider/lookup").urlParameter("domain", (Object)domain).get().go();
    }

    public ClientResponse<ActionResponse, Errors> modifyAction(UUID actionId, ActionRequest request) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").urlSegment((Object)actionId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<ApplicationResponse, Errors> reactivateApplication(UUID applicationId) {
        return this.start(ApplicationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlParameter("reactivate", (Object)true).put().go();
    }

    public ClientResponse<UserResponse, Errors> reactivateUser(UUID userId) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlSegment((Object)userId).urlParameter("reactivate", (Object)true).put().go();
    }

    public ClientResponse<UserActionResponse, Errors> reactivateUserAction(UUID userActionId) {
        return this.start(UserActionResponse.class, Errors.class).uri("/api/user-action").urlSegment((Object)userActionId).urlParameter("reactivate", (Object)true).put().go();
    }

    public ClientResponse<LoginResponse, Errors> reconcileJWT(ReconcileRequest request) {
        return this.start(LoginResponse.class, Errors.class).uri("/api/jwt/reconcile").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<RegistrationResponse, Errors> register(UUID userId, RegistrationRequest request) {
        return this.start(RegistrationResponse.class, Errors.class).uri("/api/user/registration").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<VerifyEmailResponse, Void> resendEmailVerification(String email) {
        return this.start(VerifyEmailResponse.class, Void.TYPE).uri("/api/user/verify-email").urlParameter("email", (Object)email).put().go();
    }

    public ClientResponse<VerifyRegistrationResponse, Void> resendRegistrationVerification(String email, UUID applicationId) {
        return this.start(VerifyRegistrationResponse.class, Void.TYPE).uri("/api/user/verify-registration").urlParameter("email", (Object)email).urlParameter("applicationId", (Object)applicationId).put().go();
    }

    public ClientResponse<ActionResponse, Errors> retrieveAction(UUID actionId) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").urlSegment((Object)actionId).get().go();
    }

    public ClientResponse<ActionResponse, Errors> retrieveActions(UUID userId) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").urlParameter("userId", (Object)userId).get().go();
    }

    public ClientResponse<ApplicationResponse, Void> retrieveApplication(UUID applicationId) {
        return this.start(ApplicationResponse.class, Void.TYPE).uri("/api/application").urlSegment((Object)applicationId).get().go();
    }

    public ClientResponse<ApplicationResponse, Void> retrieveApplications() {
        return this.start(ApplicationResponse.class, Void.TYPE).uri("/api/application").get().go();
    }

    public ClientResponse<AuditLogResponse, Errors> retrieveAuditLog(Integer auditLogId) {
        return this.start(AuditLogResponse.class, Errors.class).uri("/api/system/audit-log").urlSegment((Object)auditLogId).get().go();
    }

    public ClientResponse<DailyActiveUserReportResponse, Errors> retrieveDailyActiveReport(UUID applicationId, long start, long end) {
        return this.start(DailyActiveUserReportResponse.class, Errors.class).uri("/api/report/daily-active-user").urlParameter("applicationId", (Object)applicationId).urlParameter("start", (Object)start).urlParameter("end", (Object)end).get().go();
    }

    public ClientResponse<EmailTemplateResponse, Void> retrieveEmailTemplate(UUID emailTemplateId) {
        return this.start(EmailTemplateResponse.class, Void.TYPE).uri("/api/email/template").urlSegment((Object)emailTemplateId).get().go();
    }

    public ClientResponse<PreviewResponse, Errors> retrieveEmailTemplatePreview(PreviewRequest request) {
        return this.start(PreviewResponse.class, Errors.class).uri("/api/email/template/preview").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<EmailTemplateResponse, Void> retrieveEmailTemplates() {
        return this.start(EmailTemplateResponse.class, Void.TYPE).uri("/api/email/template").get().go();
    }

    public ClientResponse<GroupResponse, Errors> retrieveGroup(UUID groupId) {
        return this.start(GroupResponse.class, Errors.class).uri("/api/group").urlSegment((Object)groupId).get().go();
    }

    public ClientResponse<GroupResponse, Void> retrieveGroups() {
        return this.start(GroupResponse.class, Void.TYPE).uri("/api/group").get().go();
    }

    public ClientResponse<IdentityProviderResponse, Void> retrieveIdentityProvider(UUID identityProviderId) {
        return this.start(IdentityProviderResponse.class, Void.TYPE).uri("/api/identity-provider").urlSegment((Object)identityProviderId).get().go();
    }

    public ClientResponse<IdentityProviderResponse, Void> retrieveIdentityProviders() {
        return this.start(IdentityProviderResponse.class, Void.TYPE).uri("/api/identity-provider").get().go();
    }

    public ClientResponse<ApplicationResponse, Void> retrieveInactiveApplications() {
        return this.start(ApplicationResponse.class, Void.TYPE).uri("/api/application").urlParameter("inactive", (Object)true).get().go();
    }

    public ClientResponse<UserActionResponse, Void> retrieveInactiveUserActions() {
        return this.start(UserActionResponse.class, Void.TYPE).uri("/api/user-action").urlParameter("inactive", (Object)true).get().go();
    }

    public ClientResponse<IntegrationResponse, Void> retrieveIntegration() {
        return this.start(IntegrationResponse.class, Void.TYPE).uri("/api/integration").get().go();
    }

    public ClientResponse<PublicKeyResponse, Void> retrieveJWTPublicKey(String keyId) {
        return this.start(PublicKeyResponse.class, Void.TYPE).uri("/api/jwt/public-key").urlSegment((Object)keyId).get().go();
    }

    public ClientResponse<PublicKeyResponse, Void> retrieveJWTPublicKeys() {
        return this.start(PublicKeyResponse.class, Void.TYPE).uri("/api/jwt/public-key").get().go();
    }

    public ClientResponse<LoginReportResponse, Errors> retrieveLoginReport(UUID applicationId, long start, long end) {
        return this.start(LoginReportResponse.class, Errors.class).uri("/api/report/login").urlParameter("applicationId", (Object)applicationId).urlParameter("start", (Object)start).urlParameter("end", (Object)end).get().go();
    }

    public ClientResponse<MonthlyActiveUserReportResponse, Errors> retrieveMonthlyActiveReport(UUID applicationId, long start, long end) {
        return this.start(MonthlyActiveUserReportResponse.class, Errors.class).uri("/api/report/monthly-active-user").urlParameter("applicationId", (Object)applicationId).urlParameter("start", (Object)start).urlParameter("end", (Object)end).get().go();
    }

    public ClientResponse<OAuthConfigurationResponse, Errors> retrieveOauthConfiguration(UUID applicationId) {
        return this.start(OAuthConfigurationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"oauth-configuration").get().go();
    }

    public ClientResponse<PasswordValidationRulesResponse, Void> retrievePasswordValidationRules() {
        return this.start(PasswordValidationRulesResponse.class, Void.TYPE).uri("/api/system-configuration/password-validation-rules").get().go();
    }

    public ClientResponse<RefreshResponse, Errors> retrieveRefreshTokens(UUID userId) {
        return this.start(RefreshResponse.class, Errors.class).uri("/api/jwt/refresh").urlParameter("userId", (Object)userId).get().go();
    }

    public ClientResponse<RegistrationResponse, Errors> retrieveRegistration(UUID userId, UUID applicationId) {
        return this.start(RegistrationResponse.class, Errors.class).uri("/api/user/registration").urlSegment((Object)userId).urlSegment((Object)applicationId).get().go();
    }

    public ClientResponse<RegistrationReportResponse, Errors> retrieveRegistrationReport(UUID applicationId, long start, long end) {
        return this.start(RegistrationReportResponse.class, Errors.class).uri("/api/report/registration").urlParameter("applicationId", (Object)applicationId).urlParameter("start", (Object)start).urlParameter("end", (Object)end).get().go();
    }

    public ClientResponse<SystemConfigurationResponse, Void> retrieveSystemConfiguration() {
        return this.start(SystemConfigurationResponse.class, Void.TYPE).uri("/api/system-configuration").get().go();
    }

    public ClientResponse<TenantResponse, Errors> retrieveTenant(UUID tenantId) {
        return this.start(TenantResponse.class, Errors.class).uri("/api/tenant").urlSegment((Object)tenantId).get().go();
    }

    public ClientResponse<TenantResponse, Void> retrieveTenants() {
        return this.start(TenantResponse.class, Void.TYPE).uri("/api/tenant").get().go();
    }

    public ClientResponse<TotalsReportResponse, Void> retrieveTotalReport() {
        return this.start(TotalsReportResponse.class, Void.TYPE).uri("/api/report/totals").get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUser(UUID userId) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlSegment((Object)userId).get().go();
    }

    public ClientResponse<UserActionResponse, Void> retrieveUserAction(UUID userActionId) {
        return this.start(UserActionResponse.class, Void.TYPE).uri("/api/user-action").urlSegment((Object)userActionId).get().go();
    }

    public ClientResponse<UserActionReasonResponse, Void> retrieveUserActionReason(UUID userActionReasonId) {
        return this.start(UserActionReasonResponse.class, Void.TYPE).uri("/api/user-action-reason").urlSegment((Object)userActionReasonId).get().go();
    }

    public ClientResponse<UserActionReasonResponse, Void> retrieveUserActionReasons() {
        return this.start(UserActionReasonResponse.class, Void.TYPE).uri("/api/user-action-reason").get().go();
    }

    public ClientResponse<UserActionResponse, Void> retrieveUserActions() {
        return this.start(UserActionResponse.class, Void.TYPE).uri("/api/user-action").get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUserByChangePasswordId(String changePasswordId) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlParameter("changePasswordId", (Object)changePasswordId).get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUserByEmail(String email) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlParameter("email", (Object)email).get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUserByLoginId(String loginId) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlParameter("loginId", (Object)loginId).get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUserByUsername(String username) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlParameter("username", (Object)username).get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUserByVerificationId(String verificationId) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlParameter("verificationId", (Object)verificationId).get().go();
    }

    public ClientResponse<UserCommentResponse, Errors> retrieveUserComments(UUID userId) {
        return this.start(UserCommentResponse.class, Errors.class).uri("/api/user/comment").urlSegment((Object)userId).get().go();
    }

    public ClientResponse<UserLoginReportResponse, Errors> retrieveUserLoginReport(UUID userId, int offset, Integer limit) {
        return this.start(UserLoginReportResponse.class, Errors.class).uri("/api/report/user-login").urlParameter("userId", (Object)userId).urlParameter("offset", (Object)offset).urlParameter("limit", (Object)limit).get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUserUsingJWT(String encodedJWT) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").authorization("JWT " + encodedJWT).get().go();
    }

    public ClientResponse<WebhookResponse, Void> retrieveWebhook(UUID webhookId) {
        return this.start(WebhookResponse.class, Void.TYPE).uri("/api/webhook").urlSegment((Object)webhookId).get().go();
    }

    public ClientResponse<WebhookResponse, Void> retrieveWebhooks() {
        return this.start(WebhookResponse.class, Void.TYPE).uri("/api/webhook").get().go();
    }

    public ClientResponse<Void, Errors> revokeRefreshToken(String token, UUID userId, UUID applicationId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/jwt/refresh").urlParameter("token", (Object)token).urlParameter("userId", (Object)userId).urlParameter("applicationId", (Object)applicationId).delete().go();
    }

    public ClientResponse<AuditLogSearchResponse, Void> searchAuditLogs(AuditLogSearchRequest request) {
        return this.start(AuditLogSearchResponse.class, Void.TYPE).uri("/api/system/audit-log/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<SearchResponse, Errors> searchUsers(Collection<UUID> ids) {
        return this.start(SearchResponse.class, Errors.class).uri("/api/user/search").urlParameter("ids", ids).get().go();
    }

    public ClientResponse<SearchResponse, Errors> searchUsersByQueryString(SearchRequest request) {
        return this.start(SearchResponse.class, Errors.class).uri("/api/user/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<SendResponse, Errors> sendEmail(UUID emailTemplateId, SendRequest request) {
        return this.start(SendResponse.class, Errors.class).uri("/api/email/send").urlSegment((Object)emailTemplateId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<Void, Errors> sendTwoFactorCode(TwoFactorSendRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/two-factor/send").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<Void, Errors> sendTwoFactorCodeForLogin(String twoFactorId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/two-factor/send").urlSegment((Object)twoFactorId).post().go();
    }

    public ClientResponse<LoginResponse, Errors> twoFactorLogin(TwoFactorLoginRequest request) {
        return this.start(LoginResponse.class, Errors.class).uri("/api/two-factor/login").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).post().go();
    }

    public ClientResponse<ApplicationResponse, Errors> updateApplication(UUID applicationId, ApplicationRequest request) {
        return this.start(ApplicationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<ApplicationResponse, Errors> updateApplicationRole(UUID applicationId, UUID roleId, ApplicationRequest request) {
        return this.start(ApplicationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"role").urlSegment((Object)roleId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<EmailTemplateResponse, Errors> updateEmailTemplate(UUID emailTemplateId, EmailTemplateRequest request) {
        return this.start(EmailTemplateResponse.class, Errors.class).uri("/api/email/template").urlSegment((Object)emailTemplateId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<GroupResponse, Errors> updateGroup(UUID groupId, GroupRequest request) {
        return this.start(GroupResponse.class, Errors.class).uri("/api/group").urlSegment((Object)groupId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<IdentityProviderResponse, Errors> updateIdentityProvider(UUID identityProviderId, IdentityProviderRequest request) {
        return this.start(IdentityProviderResponse.class, Errors.class).uri("/api/identity-provider").urlSegment((Object)identityProviderId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<IntegrationResponse, Errors> updateIntegrations(IntegrationRequest request) {
        return this.start(IntegrationResponse.class, Errors.class).uri("/api/integration").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<RegistrationResponse, Errors> updateRegistration(UUID userId, RegistrationRequest request) {
        return this.start(RegistrationResponse.class, Errors.class).uri("/api/user/registration").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<SystemConfigurationResponse, Errors> updateSystemConfiguration(SystemConfigurationRequest request) {
        return this.start(SystemConfigurationResponse.class, Errors.class).uri("/api/system-configuration").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<TenantResponse, Errors> updateTenant(UUID tenantId, TenantRequest request) {
        return this.start(TenantResponse.class, Errors.class).uri("/api/tenant").urlSegment((Object)tenantId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<UserResponse, Errors> updateUser(UUID userId, UserRequest request) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<UserActionResponse, Errors> updateUserAction(UUID userActionId, UserActionRequest request) {
        return this.start(UserActionResponse.class, Errors.class).uri("/api/user-action").urlSegment((Object)userActionId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<UserActionReasonResponse, Errors> updateUserActionReason(UUID userActionReasonId, UserActionReasonRequest request) {
        return this.start(UserActionReasonResponse.class, Errors.class).uri("/api/user-action-reason").urlSegment((Object)userActionReasonId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<WebhookResponse, Errors> updateWebhook(UUID webhookId, WebhookRequest request) {
        return this.start(WebhookResponse.class, Errors.class).uri("/api/webhook").urlSegment((Object)webhookId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, objectMapper)).put().go();
    }

    public ClientResponse<ValidateResponse, Void> validateJWT(String encodedJWT) {
        return this.start(ValidateResponse.class, Void.TYPE).uri("/api/jwt/validate").authorization("JWT " + encodedJWT).get().go();
    }

    public ClientResponse<Void, Void> verifyEmail(String verificationId) {
        return this.start(Void.TYPE, Void.TYPE).uri("/api/user/verify-email").urlSegment((Object)verificationId).post().go();
    }

    public ClientResponse<Void, Void> verifyRegistration(String verificationId) {
        return this.start(Void.TYPE, Void.TYPE).uri("/api/user/verify-registration").urlSegment((Object)verificationId).post().go();
    }

    protected <T, U> RESTClient<T, U> start(Class<T> type, Class<U> errorType) {
        RESTClient client = new RESTClient(type, errorType).authorization(this.apiKey).successResponseHandler((RESTClient.ResponseHandler)(type != Void.TYPE ? new JSONResponseHandler(type, objectMapper) : null)).errorResponseHandler((RESTClient.ResponseHandler)(errorType != Void.TYPE ? new JSONResponseHandler(errorType, objectMapper) : null)).url(this.baseURL).connectTimeout(this.connectTimeout).readTimeout(this.readTimeout);
        if (this.tenantId != null) {
            client.header(TENANT_ID_HEADER, this.tenantId);
        }
        return client;
    }
}

