/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.primeframework.jwt.domain.JWT;

public class JWTManager {
    private static final ScheduledThreadPoolExecutor executorService;
    private static final Map<UUID, ZonedDateTime> revokedJWTs;

    public static boolean isValid(JWT jwt) {
        UUID userId = UUID.fromString(jwt.subject);
        ZonedDateTime expiration = revokedJWTs.get(userId);
        return expiration == null || expiration.isBefore(jwt.expiration);
    }

    public static void revoke(UUID userId, int durationSeconds) {
        ZonedDateTime expiration = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(durationSeconds);
        revokedJWTs.put(userId, expiration);
    }

    static {
        revokedJWTs = new ConcurrentHashMap<UUID, ZonedDateTime>();
        executorService = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setName("JWTManager Thread");
            t.setDaemon(true);
            return t;
        });
        executorService.schedule(() -> revokedJWTs.entrySet().removeIf(e -> ((ZonedDateTime)e.getValue()).isBefore(ZonedDateTime.now(ZoneOffset.UTC))), 7L, TimeUnit.SECONDS);
    }
}

