/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.ToString;
import io.fusionauth.domain.ApplicationRole;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.CleanSpeakConfiguration;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.JWTConfiguration;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.oauth2.OAuth2Configuration;
import io.fusionauth.domain.util.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class Application
implements Buildable<Application>,
_InternalJSONColumn {
    public static final UUID FUSIONAUTH_APP_ID = UUID.fromString("3c219e58-ed0e-4b18-ad48-f4f92793ae32");
    public boolean active;
    @InternalJSONColumn
    public AuthenticationTokenConfiguration authenticationTokenConfiguration = new AuthenticationTokenConfiguration();
    @InternalJSONColumn
    public CleanSpeakConfiguration cleanSpeakConfiguration;
    public Map<String, Object> data = new LinkedHashMap<String, Object>();
    public UUID id;
    @InternalJSONColumn
    public JWTConfiguration jwtConfiguration;
    public String name;
    @InternalJSONColumn
    public OAuth2Configuration oauthConfiguration = new OAuth2Configuration();
    public List<ApplicationRole> roles = new ArrayList<ApplicationRole>();
    public UUID tenantId;
    public UUID verificationEmailTemplateId;
    @InternalJSONColumn
    public boolean verifyRegistration;

    public Application() {
    }

    public Application(String name) {
        this.name = name;
    }

    public Application(UUID id, String name, boolean active, CleanSpeakConfiguration cleanSpeakConfiguration, ApplicationRole ... roles) {
        this.id = id;
        this.name = name;
        this.active = active;
        this.cleanSpeakConfiguration = cleanSpeakConfiguration;
        Collections.addAll(this.roles, roles);
    }

    public Application(UUID id, String name, boolean active, CleanSpeakConfiguration cleanSpeakConfiguration, OAuth2Configuration oAuthConfiguration, ApplicationRole ... roles) {
        this.id = id;
        this.name = name;
        this.active = active;
        this.cleanSpeakConfiguration = cleanSpeakConfiguration;
        this.oauthConfiguration = oAuthConfiguration;
        Collections.addAll(this.roles, roles);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application that = (Application)o;
        return this.active == that.active && this.verifyRegistration == that.verifyRegistration && Objects.equals(this.authenticationTokenConfiguration, that.authenticationTokenConfiguration) && Objects.equals(this.cleanSpeakConfiguration, that.cleanSpeakConfiguration) && Objects.equals(this.data, that.data) && Objects.equals(this.jwtConfiguration, that.jwtConfiguration) && Objects.equals(this.name, that.name) && Objects.equals(this.oauthConfiguration, that.oauthConfiguration) && Objects.equals(this.roles, that.roles) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.verificationEmailTemplateId, that.verificationEmailTemplateId);
    }

    public ApplicationRole getRole(String name) {
        for (ApplicationRole role : this.roles) {
            if (!role.name.equals(name)) continue;
            return role;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.active, this.authenticationTokenConfiguration, this.cleanSpeakConfiguration, this.data, this.jwtConfiguration, this.name, this.oauthConfiguration, this.roles, this.tenantId, this.verificationEmailTemplateId, this.verifyRegistration);
    }

    public void normalize() {
        this.name = Normalizer.trim(this.name);
        if (this.cleanSpeakConfiguration != null) {
            this.cleanSpeakConfiguration.normalize();
        }
        if (this.oauthConfiguration != null) {
            this.oauthConfiguration.normalize();
        }
        if (this.jwtConfiguration != null) {
            this.jwtConfiguration.normalize();
            this.jwtConfiguration.issuer = null;
            this.jwtConfiguration.refreshTokenTimeToLiveInMinutes = 0;
        }
        this.roles.forEach(ApplicationRole::normalize);
    }

    public Application secure() {
        if (this.oauthConfiguration != null) {
            this.oauthConfiguration.clientSecret = null;
        }
        return this;
    }

    public Application sortRoles() {
        this.roles.sort(ApplicationRole::compareTo);
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class AuthenticationTokenConfiguration
    extends Enableable {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode());
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

