/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import java.util.Objects;
import org.primeframework.jwt.domain.Algorithm;

public class JWTConfiguration
extends Enableable
implements Buildable<JWTConfiguration> {
    public Algorithm algorithm;
    public String issuer;
    public String privateKey;
    public String publicKey;
    public Integer refreshTokenTimeToLiveInMinutes;
    public String secret;
    public int timeToLiveInSeconds;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JWTConfiguration)) {
            return false;
        }
        JWTConfiguration that = (JWTConfiguration)o;
        return super.equals(o) && Objects.equals(this.algorithm, that.algorithm) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.privateKey, that.privateKey) && Objects.equals(this.publicKey, that.publicKey) && Objects.equals(this.refreshTokenTimeToLiveInMinutes, that.refreshTokenTimeToLiveInMinutes) && Objects.equals(this.secret, that.secret) && Objects.equals(this.timeToLiveInSeconds, that.timeToLiveInSeconds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.algorithm, this.issuer, this.privateKey, this.publicKey, this.refreshTokenTimeToLiveInMinutes, this.secret, this.timeToLiveInSeconds);
    }

    public void normalize() {
        if (this.publicKey != null) {
            this.publicKey = this.publicKey.replace("\r\n", "\n").replace("\r", "\n");
        }
        if (this.privateKey != null) {
            this.privateKey = this.privateKey.replace("\r\n", "\n").replace("\r", "\n");
        }
    }

    public JWTConfiguration secure() {
        this.privateKey = null;
        this.secret = null;
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

