/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.FailedAuthenticationConfiguration;
import io.fusionauth.domain.JWTConfiguration;
import io.fusionauth.domain.MaximumPasswordAge;
import io.fusionauth.domain.MinimumPasswordAge;
import io.fusionauth.domain.PasswordEncryptionConfiguration;
import io.fusionauth.domain.PasswordValidationRules;
import io.fusionauth.domain.TransactionType;
import io.fusionauth.domain.event.EventType;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import java.net.URI;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class SystemConfiguration
implements Buildable<SystemConfiguration>,
_InternalJSONColumn {
    @InternalJSONColumn
    public String cookieEncryptionIV;
    @InternalJSONColumn
    public String cookieEncryptionKey;
    public Map<String, Object> data = new HashMap<String, Object>();
    @InternalJSONColumn
    public EmailConfiguration emailConfiguration = new EmailConfiguration();
    @InternalJSONColumn
    public EventConfiguration eventConfiguration = new EventConfiguration();
    @InternalJSONColumn
    public ExternalIdentifierConfiguration externalIdentifierConfiguration = new ExternalIdentifierConfiguration();
    @InternalJSONColumn
    public FailedAuthenticationConfiguration failedAuthenticationConfiguration = new FailedAuthenticationConfiguration();
    public int httpSessionMaxInactiveInterval = 3600;
    @InternalJSONColumn
    public JWTConfiguration jwtConfiguration = new JWTConfiguration();
    public URI logoutURL;
    @InternalJSONColumn
    public MaximumPasswordAge maximumPasswordAge = new MaximumPasswordAge();
    @InternalJSONColumn
    public MinimumPasswordAge minimumPasswordAge = new MinimumPasswordAge();
    @InternalJSONColumn
    public PasswordEncryptionConfiguration passwordEncryptionConfiguration = new PasswordEncryptionConfiguration();
    @InternalJSONColumn
    public PasswordValidationRules passwordValidationRules = new PasswordValidationRules();
    public ZoneId reportTimezone;
    @InternalJSONColumn
    public UIConfiguration uiConfiguration = new UIConfiguration();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemConfiguration)) {
            return false;
        }
        SystemConfiguration that = (SystemConfiguration)o;
        return this.httpSessionMaxInactiveInterval == that.httpSessionMaxInactiveInterval && Objects.equals(this.cookieEncryptionIV, that.cookieEncryptionIV) && Objects.equals(this.cookieEncryptionKey, that.cookieEncryptionKey) && Objects.equals(this.data, that.data) && Objects.equals(this.emailConfiguration, that.emailConfiguration) && Objects.equals(this.eventConfiguration, that.eventConfiguration) && Objects.equals(this.externalIdentifierConfiguration, that.externalIdentifierConfiguration) && Objects.equals(this.failedAuthenticationConfiguration, that.failedAuthenticationConfiguration) && Objects.equals(this.jwtConfiguration, that.jwtConfiguration) && Objects.equals(this.logoutURL, that.logoutURL) && Objects.equals(this.maximumPasswordAge, that.maximumPasswordAge) && Objects.equals(this.minimumPasswordAge, that.minimumPasswordAge) && Objects.equals(this.passwordEncryptionConfiguration, that.passwordEncryptionConfiguration) && Objects.equals(this.passwordValidationRules, that.passwordValidationRules) && Objects.equals(this.reportTimezone, that.reportTimezone) && Objects.equals(this.uiConfiguration, that.uiConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.cookieEncryptionIV, this.cookieEncryptionKey, this.data, this.emailConfiguration, this.eventConfiguration, this.externalIdentifierConfiguration, this.failedAuthenticationConfiguration, this.httpSessionMaxInactiveInterval, this.jwtConfiguration, this.logoutURL, this.maximumPasswordAge, this.minimumPasswordAge, this.passwordEncryptionConfiguration, this.passwordValidationRules, this.reportTimezone, this.uiConfiguration);
    }

    public void normalize() {
        if (this.jwtConfiguration != null) {
            this.jwtConfiguration.normalize();
        }
    }

    public SystemConfiguration secure() {
        if (this.jwtConfiguration != null) {
            this.jwtConfiguration.secure();
        }
        this.cookieEncryptionIV = null;
        this.cookieEncryptionKey = null;
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class UIConfiguration {
        public String headerColor;
        public LoginTheme loginTheme;
        public String logoURL;
        public String menuFontColor;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UIConfiguration)) {
                return false;
            }
            UIConfiguration that = (UIConfiguration)o;
            return Objects.equals(this.logoURL, that.logoURL) && Objects.equals(this.headerColor, that.headerColor) && Objects.equals(this.loginTheme, that.loginTheme) && Objects.equals(this.menuFontColor, that.menuFontColor);
        }

        public int hashCode() {
            return Objects.hash(this.logoURL, this.headerColor, this.loginTheme, this.menuFontColor);
        }

        public static class LoginTheme
        extends Enableable {
            public String stylesheet;

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof LoginTheme)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                LoginTheme that = (LoginTheme)o;
                return Objects.equals(this.stylesheet, that.stylesheet);
            }

            @Override
            public int hashCode() {
                return Objects.hash(super.hashCode(), this.stylesheet);
            }
        }
    }

    public static class ExternalIdentifierConfiguration
    implements Buildable<ExternalIdentifierConfiguration> {
        public int authorizationGrantIdTimeToLiveInSeconds;
        public int changePasswordIdTimeToLiveInSeconds;
        public int emailVerificationIdTimeToLiveInSeconds;
        public int registrationVerificationIdTimeToLiveInSeconds;
        public int setupPasswordIdTimeToLiveInSeconds;
        public int twoFactorIdTimeToLiveInSeconds;
        public int twoFactorTrustIdTimeToLiveInSeconds;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExternalIdentifierConfiguration)) {
                return false;
            }
            ExternalIdentifierConfiguration that = (ExternalIdentifierConfiguration)o;
            return this.authorizationGrantIdTimeToLiveInSeconds == that.authorizationGrantIdTimeToLiveInSeconds && this.changePasswordIdTimeToLiveInSeconds == that.changePasswordIdTimeToLiveInSeconds && this.emailVerificationIdTimeToLiveInSeconds == that.emailVerificationIdTimeToLiveInSeconds && this.registrationVerificationIdTimeToLiveInSeconds == that.registrationVerificationIdTimeToLiveInSeconds && this.setupPasswordIdTimeToLiveInSeconds == that.setupPasswordIdTimeToLiveInSeconds && this.twoFactorIdTimeToLiveInSeconds == that.twoFactorIdTimeToLiveInSeconds && this.twoFactorTrustIdTimeToLiveInSeconds == that.twoFactorTrustIdTimeToLiveInSeconds;
        }

        public int hashCode() {
            return Objects.hash(this.authorizationGrantIdTimeToLiveInSeconds, this.changePasswordIdTimeToLiveInSeconds, this.emailVerificationIdTimeToLiveInSeconds, this.registrationVerificationIdTimeToLiveInSeconds, this.setupPasswordIdTimeToLiveInSeconds, this.twoFactorIdTimeToLiveInSeconds, this.twoFactorTrustIdTimeToLiveInSeconds);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class EventConfiguration
    implements Buildable<EventConfiguration> {
        public Map<EventType, EventConfigurationData> events = new HashMap<EventType, EventConfigurationData>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventConfiguration that = (EventConfiguration)o;
            return Objects.equals(this.events, that.events);
        }

        public int hashCode() {
            return Objects.hash(this.events);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }

        public static class EventConfigurationData
        extends Enableable {
            public TransactionType transactionType;

            @JacksonConstructor
            public EventConfigurationData() {
            }

            public EventConfigurationData(boolean enabled, TransactionType transactionType) {
                this.enabled = enabled;
                this.transactionType = transactionType;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                EventConfigurationData that = (EventConfigurationData)o;
                return super.equals(o) && Objects.equals((Object)this.transactionType, (Object)that.transactionType);
            }

            @Override
            public int hashCode() {
                return Objects.hash(new Object[]{super.hashCode(), this.transactionType});
            }

            public String toString() {
                return ToString.toString((Object)this);
            }
        }
    }

    public static class EmailConfiguration
    extends Enableable
    implements Buildable<EmailConfiguration> {
        public UUID forgotPasswordEmailTemplateId;
        public String host;
        public String password;
        public Integer port;
        public EmailSecurityType security;
        public UUID setPasswordEmailTemplateId;
        public String username;
        public UUID verificationEmailTemplateId;
        public boolean verifyEmail;
        public boolean verifyEmailWhenChanged;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EmailConfiguration)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EmailConfiguration that = (EmailConfiguration)o;
            return this.verifyEmail == that.verifyEmail && this.verifyEmailWhenChanged == that.verifyEmailWhenChanged && Objects.equals(this.forgotPasswordEmailTemplateId, that.forgotPasswordEmailTemplateId) && Objects.equals(this.host, that.host) && Objects.equals(this.password, that.password) && Objects.equals(this.port, that.port) && this.security == that.security && Objects.equals(this.setPasswordEmailTemplateId, that.setPasswordEmailTemplateId) && Objects.equals(this.username, that.username) && Objects.equals(this.verificationEmailTemplateId, that.verificationEmailTemplateId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.forgotPasswordEmailTemplateId, this.host, this.password, this.port, this.security, this.setPasswordEmailTemplateId, this.username, this.verificationEmailTemplateId, this.verifyEmail, this.verifyEmailWhenChanged});
        }

        public String toString() {
            return ToString.toString((Object)this);
        }

        public static enum EmailSecurityType {
            NONE,
            SSL,
            TLS;

        }
    }
}

