/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.ToString;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class URLQueryBuilder {
    private final StringBuilder build = new StringBuilder();

    public static URLQueryBuilder builder() {
        return new URLQueryBuilder();
    }

    public String query() {
        return this.build.toString();
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public URLQueryBuilder with(String name, Object value) {
        if (value == null) {
            return this;
        }
        if (this.build.length() > 0) {
            this.build.append("&");
        }
        try {
            this.build.append(name).append("=").append(URLEncoder.encode(value.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }
}

