/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Application;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.ContentStatus;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;

public class UserRegistration
implements Buildable<UserRegistration>,
_InternalJSONColumn {
    public final Map<String, Object> data;
    @InternalJSONColumn
    public final List<Locale> preferredLanguages = new ArrayList<Locale>();
    @JsonIgnore
    public Application application;
    public UUID applicationId;
    public String authenticationToken;
    public UUID cleanSpeakId;
    public UUID id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastLoginInstant;
    public SortedSet<String> roles = new TreeSet<String>();
    public String timezone;
    @JsonIgnore
    public UUID userId;
    public String username;
    public ContentStatus usernameStatus;
    public boolean verified;

    public UserRegistration() {
        this.data = new LinkedHashMap<String, Object>();
    }

    public UserRegistration(UUID id, UUID applicationId, UUID userId, ZonedDateTime lastLoginInstant, String username, ContentStatus usernameStatus, UUID cleanSpeakId, Map<String, Object> data, List<Locale> preferredLanguages, String ... roles) {
        this.id = id;
        this.applicationId = applicationId;
        this.userId = userId;
        this.cleanSpeakId = cleanSpeakId;
        this.lastLoginInstant = lastLoginInstant;
        this.username = username;
        this.usernameStatus = usernameStatus;
        this.verified = true;
        this.preferredLanguages.addAll(preferredLanguages);
        this.data = new LinkedHashMap<String, Object>();
        if (data != null) {
            this.data.putAll(data);
        }
        Collections.addAll(this.roles, roles);
    }

    public UserRegistration(UserRegistration userRegistration) {
        this.application = userRegistration.application;
        this.applicationId = userRegistration.applicationId;
        this.authenticationToken = userRegistration.authenticationToken;
        this.cleanSpeakId = userRegistration.cleanSpeakId;
        this.id = userRegistration.id;
        this.insertInstant = userRegistration.insertInstant;
        this.lastLoginInstant = userRegistration.lastLoginInstant;
        this.preferredLanguages.addAll(userRegistration.preferredLanguages);
        this.roles.addAll(userRegistration.roles);
        this.timezone = userRegistration.timezone;
        this.userId = userRegistration.userId;
        this.username = userRegistration.username;
        this.usernameStatus = userRegistration.usernameStatus;
        this.verified = userRegistration.verified;
        this.data = new LinkedHashMap<String, Object>();
        if (userRegistration.data != null) {
            this.data.putAll(userRegistration.data);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserRegistration)) {
            return false;
        }
        UserRegistration that = (UserRegistration)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.authenticationToken, that.authenticationToken) && Objects.equals(this.cleanSpeakId, that.cleanSpeakId) && Objects.equals(this.data, that.data) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastLoginInstant, that.lastLoginInstant) && Objects.equals(this.roles, that.roles) && Objects.equals(this.userId, that.userId) && Objects.equals(this.username, that.username) && Objects.equals((Object)this.usernameStatus, (Object)that.usernameStatus) && Objects.equals(this.verified, that.verified);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.applicationId, this.authenticationToken, this.cleanSpeakId, this.data, this.insertInstant, this.lastLoginInstant, this.roles, this.userId, this.username, this.usernameStatus});
    }

    public void normalize() {
        this.authenticationToken = Normalizer.trimToNull(this.authenticationToken);
        this.preferredLanguages.removeIf(Objects::isNull);
        this.username = Normalizer.trim(this.username);
        Normalizer.removeEmpty(this.data);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

