/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum EventType {
    UserDelete("user.delete"),
    UserCreate("user.create"),
    UserUpdate("user.update"),
    UserDeactivate("user.deactivate"),
    UserBulkCreate("user.bulk.create"),
    UserReactivate("user.reactivate"),
    UserAction("user.action"),
    JWTRefreshTokenRevoke("jwt.refresh-token.revoke"),
    JWTPublicKeyUpdate("jwt.public-key.update"),
    Test("test");

    private static Map<String, EventType> nameMap;
    private final String eventName;

    private EventType(String eventName) {
        this.eventName = eventName;
    }

    @JsonCreator
    public static EventType forValue(String value) {
        return nameMap.get(value);
    }

    @JsonValue
    public String eventName() {
        return this.eventName;
    }

    static {
        nameMap = new HashMap<String, EventType>(EventType.values().length);
        for (EventType eventType : EventType.values()) {
            nameMap.put(eventType.eventName(), eventType);
        }
    }
}

