/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.event.ApplicationEvent;
import io.fusionauth.domain.event.BaseEvent;
import io.fusionauth.domain.event.EventType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class JWTPublicKeyUpdateEvent
extends BaseEvent
implements Buildable<JWTPublicKeyUpdateEvent>,
ApplicationEvent {
    public Set<UUID> applicationIds;

    @JacksonConstructor
    public JWTPublicKeyUpdateEvent() {
    }

    public JWTPublicKeyUpdateEvent(UUID applicationId) {
        this.applicationIds = new HashSet<UUID>();
        this.applicationIds.add(applicationId);
    }

    public JWTPublicKeyUpdateEvent(Set<UUID> applicationIds) {
        this.applicationIds = applicationIds;
    }

    @Override
    public Collection<UUID> applicationIds() {
        return this.applicationIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWTPublicKeyUpdateEvent that = (JWTPublicKeyUpdateEvent)o;
        return super.equals(o) && Objects.equals(this.applicationIds, that.applicationIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationIds);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    @Override
    public EventType type() {
        return EventType.JWTPublicKeyUpdate;
    }
}

