/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.oauth2;

import com.inversoft.json.ToString;
import io.fusionauth.domain.oauth2.Expiring;
import java.net.URI;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;

public class AuthorizationCode
implements Expiring {
    public String clientId;
    public String code;
    public ZonedDateTime createInstant;
    public String encodedJWT;
    public ZonedDateTime expiresInstant;
    public URI redirectURI;
    public UUID userId;

    public AuthorizationCode(String clientId, String code, ZonedDateTime createInstant, ZonedDateTime expiresInstant, URI redirectURI, UUID userId, String encodedJWT) {
        this.clientId = clientId;
        this.code = code;
        this.createInstant = createInstant;
        this.encodedJWT = encodedJWT;
        this.expiresInstant = expiresInstant;
        this.redirectURI = redirectURI;
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationCode that = (AuthorizationCode)o;
        return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.code, that.code) && Objects.equals(this.createInstant, that.createInstant) && Objects.equals(this.encodedJWT, that.encodedJWT) && Objects.equals(this.expiresInstant, that.expiresInstant) && Objects.equals(this.redirectURI, that.redirectURI) && Objects.equals(this.userId, that.userId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.code, this.createInstant, this.encodedJWT, this.expiresInstant, this.redirectURI, this.userId);
    }

    @Override
    public boolean isExpired() {
        return ZonedDateTime.now(ZoneOffset.UTC).isAfter(this.expiresInstant);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

