/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.util;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Normalizer {
    public static <T, U> void removeEmpty(Map<T, U> map) {
        Iterator<T> i = map.keySet().iterator();
        while (i.hasNext()) {
            T key = i.next();
            if (map.get(key) != null) continue;
            i.remove();
        }
    }

    public static <T> void removeEmpty(List<T> list) {
        list.removeIf(Objects::isNull);
    }

    public static String toLowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String trim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim();
    }

    public static <T> void trimMap(Map<T, String> map) {
        map.forEach((key, value) -> {
            if (value != null) {
                map.put(key, value.trim());
            }
        });
    }

    public static String trimToNull(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        return str;
    }

    public static ZonedDateTime truncateToMilliseconds(ZonedDateTime time) {
        if (time == null) {
            return null;
        }
        return time.truncatedTo(ChronoUnit.MILLIS);
    }
}

