/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.Integration;
import io.fusionauth.domain.util.Normalizer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class CleanSpeakConfiguration
extends Enableable
implements Buildable<CleanSpeakConfiguration>,
Integration {
    public String apiKey;
    public List<UUID> applicationIds = new ArrayList<UUID>();
    public URI url;
    public UsernameModeration usernameModeration = new UsernameModeration();

    public CleanSpeakConfiguration() {
    }

    public CleanSpeakConfiguration(String apiKey, URI url, UsernameModeration usernameModeration, UUID ... applicationIds) {
        this.apiKey = apiKey;
        this.url = url;
        this.usernameModeration = usernameModeration;
        Collections.addAll(this.applicationIds, applicationIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CleanSpeakConfiguration)) {
            return false;
        }
        CleanSpeakConfiguration that = (CleanSpeakConfiguration)o;
        return super.equals(o) && Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.usernameModeration, that.usernameModeration) && Objects.equals(this.url, that.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.apiKey, this.usernameModeration, this.url);
    }

    public void normalize() {
        this.apiKey = Normalizer.trim(this.apiKey);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class UsernameModeration
    extends Enableable
    implements Buildable<UsernameModeration> {
        public UUID applicationId;

        public UsernameModeration() {
        }

        public UsernameModeration(UUID applicationId, boolean enabled) {
            this.applicationId = applicationId;
            this.enabled = enabled;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UsernameModeration that = (UsernameModeration)o;
            return super.equals(o) && Objects.equals(this.applicationId, that.applicationId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.applicationId);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

