/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.api.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.User;
import io.fusionauth.domain.UserAction;
import io.fusionauth.domain.UserActionLog;
import io.fusionauth.domain.UserActionReason;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class ActionRequest {
    public ActionData action;
    public boolean broadcast;

    @JacksonConstructor
    public ActionRequest() {
    }

    public ActionRequest(ActionData action, boolean broadcast) {
        this.action = action;
        this.broadcast = broadcast;
    }

    public void normalize() {
        if (this.action != null) {
            this.action.normalize();
        }
    }

    public static class ActionData
    implements Buildable<ActionData> {
        @JsonIgnore
        public UserAction action;
        @JsonIgnore
        public User actionee;
        public UUID actioneeUserId;
        @JsonIgnore
        public User actioner;
        public UUID actionerUserId;
        public List<UUID> applicationIds;
        public String comment;
        public boolean emailUser;
        public ZonedDateTime expiry;
        @JsonIgnore
        public UserActionLog log;
        public boolean notifyUser;
        public String option;
        @JsonIgnore
        public UserActionReason reason;
        public UUID reasonId;
        public UUID userActionId;

        public ActionData() {
        }

        public ActionData(UUID userActionId, UUID actioneeUserId, UUID actionerUserId, String comment, ZonedDateTime expiry, boolean notifyUser, boolean emailUser, String option, UUID reasonId, UUID ... applicationIds) {
            this.userActionId = userActionId;
            this.actioneeUserId = actioneeUserId;
            this.actionerUserId = actionerUserId;
            this.comment = comment;
            this.expiry = expiry;
            this.notifyUser = notifyUser;
            this.emailUser = emailUser;
            this.option = option;
            this.reasonId = reasonId;
            this.normalize();
            Collections.addAll(this.applicationIds, applicationIds);
        }

        public void normalize() {
            this.comment = Normalizer.trim(this.comment);
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<UUID>();
            } else {
                Normalizer.removeEmpty(this.applicationIds);
            }
        }
    }
}

