/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.oauth2;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.oauth2.GrantType;
import io.fusionauth.domain.util.Normalizer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class OAuth2Configuration
implements Buildable<OAuth2Configuration> {
    public List<URI> authorizedOriginURLs = new ArrayList<URI>();
    public List<URI> authorizedRedirectURLs = new ArrayList<URI>();
    public String clientId;
    public String clientSecret;
    public Set<GrantType> enabledGrants = new TreeSet<GrantType>(Comparator.comparing(Enum::name, Comparator.reverseOrder()));
    public boolean generateRefreshTokens;
    public URI logoutURL;
    public boolean requireClientAuthentication = true;

    public OAuth2Configuration() {
    }

    public OAuth2Configuration(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuth2Configuration)) {
            return false;
        }
        OAuth2Configuration that = (OAuth2Configuration)o;
        return this.requireClientAuthentication == that.requireClientAuthentication && this.generateRefreshTokens == that.generateRefreshTokens && Objects.equals(this.authorizedOriginURLs, that.authorizedOriginURLs) && Objects.equals(this.authorizedRedirectURLs, that.authorizedRedirectURLs) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientSecret, that.clientSecret) && Objects.equals(this.enabledGrants, that.enabledGrants) && Objects.equals(this.logoutURL, that.logoutURL);
    }

    public int hashCode() {
        return Objects.hash(this.authorizedOriginURLs, this.authorizedRedirectURLs, this.clientId, this.clientSecret, this.enabledGrants, this.logoutURL, this.requireClientAuthentication, this.generateRefreshTokens);
    }

    public void normalize() {
        Normalizer.removeEmpty(this.authorizedOriginURLs);
        Normalizer.removeEmpty(this.authorizedRedirectURLs);
        this.clientId = Normalizer.trim(this.clientId);
        this.clientSecret = Normalizer.trim(this.clientSecret);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

