/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.DomainBasedIdentityProvider;
import io.fusionauth.domain.provider.ExternalJWTApplicationConfiguration;
import io.fusionauth.domain.provider.IdentityProviderOauth2Configuration;
import io.fusionauth.domain.provider.IdentityProviderType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ExternalJWTIdentityProvider
extends BaseIdentityProvider<ExternalJWTApplicationConfiguration>
implements Buildable<ExternalJWTIdentityProvider>,
DomainBasedIdentityProvider {
    @InternalJSONColumn
    public final Map<String, String> claimMap = new LinkedHashMap<String, String>();
    public final Set<String> domains = new HashSet<String>();
    @InternalJSONColumn
    public final Map<String, String> keys = new HashMap<String, String>();
    @InternalJSONColumn
    public String headerKeyParameter;
    @InternalJSONColumn
    public IdentityProviderOauth2Configuration oauth2 = new IdentityProviderOauth2Configuration();
    @InternalJSONColumn
    public String uniqueIdentityClaim;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalJWTIdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalJWTIdentityProvider that = (ExternalJWTIdentityProvider)o;
        return Objects.equals(this.claimMap, that.claimMap) && Objects.equals(this.headerKeyParameter, that.headerKeyParameter) && Objects.equals(this.keys, that.keys) && Objects.equals(this.oauth2, that.oauth2) && Objects.equals(this.uniqueIdentityClaim, that.uniqueIdentityClaim) && Objects.equals(this.domains, that.domains);
    }

    @Override
    public Set<String> getDomains() {
        return this.domains;
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.ExternalJWT;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.claimMap, this.headerKeyParameter, this.keys, this.oauth2, this.uniqueIdentityClaim, this.domains);
    }

    @Override
    public void normalize() {
        super.normalize();
        this.normalizeDomains();
        this.keys.entrySet().removeIf(entry -> entry.getKey() == null || entry.getValue() == null || ((String)entry.getValue()).isEmpty());
        this.keys.entrySet().forEach(entry -> entry.setValue(((String)entry.getValue()).trim().replace("\r\n", "\n").replace("\r", "\n")));
    }

    public ExternalJWTIdentityProvider secure() {
        if (this.oauth2 != null) {
            this.oauth2.secure();
        }
        this.claimMap.clear();
        this.keys.clear();
        this.headerKeyParameter = null;
        this.uniqueIdentityClaim = null;
        this.domains.clear();
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

