/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.LocalizedStrings;
import io.fusionauth.domain.TransactionType;
import io.fusionauth.domain.UserActionOption;
import io.fusionauth.domain.util.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class UserAction
implements Comparable<UserAction>,
Buildable<UserAction> {
    public boolean active;
    public UUID cancelEmailTemplateId;
    public UUID endEmailTemplateId;
    public UUID id;
    public boolean includeEmailInEventJSON;
    public LocalizedStrings localizedNames;
    public UUID modifyEmailTemplateId;
    public String name;
    public List<UserActionOption> options = new ArrayList<UserActionOption>();
    public boolean preventLogin;
    public boolean sendEndEvent;
    public UUID startEmailTemplateId;
    public boolean temporal;
    public TransactionType transactionType;
    public boolean userEmailingEnabled;
    public boolean userNotificationsEnabled;

    public UserAction() {
    }

    public UserAction(String name) {
        this.name = name;
    }

    public UserAction(UUID id, String name, boolean active, LocalizedStrings localizedNames, boolean preventLogin, boolean sendEndEvent, boolean temporal, boolean userNotificationsEnabled, boolean userEmailingEnabled, boolean includeEmailInEventJSON, UUID startEmailTemplateId, UUID modifyEmailTemplateId, UUID cancelEmailTemplateId, UUID endEmailTemplateId, UserActionOption ... options) {
        this.id = id;
        this.active = active;
        this.name = name;
        this.includeEmailInEventJSON = includeEmailInEventJSON;
        this.localizedNames = localizedNames;
        this.preventLogin = preventLogin;
        this.sendEndEvent = sendEndEvent;
        this.temporal = temporal;
        this.userNotificationsEnabled = userNotificationsEnabled;
        this.startEmailTemplateId = startEmailTemplateId;
        this.modifyEmailTemplateId = modifyEmailTemplateId;
        this.cancelEmailTemplateId = cancelEmailTemplateId;
        this.endEmailTemplateId = endEmailTemplateId;
        this.userEmailingEnabled = userEmailingEnabled;
        Collections.addAll(this.options, options);
    }

    @Override
    public int compareTo(UserAction o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserAction)) {
            return false;
        }
        UserAction that = (UserAction)o;
        return Objects.equals(this.active, that.active) && Objects.equals(this.includeEmailInEventJSON, that.includeEmailInEventJSON) && Objects.equals(this.preventLogin, that.preventLogin) && Objects.equals(this.sendEndEvent, that.sendEndEvent) && Objects.equals(this.temporal, that.temporal) && Objects.equals((Object)this.transactionType, (Object)that.transactionType) && Objects.equals(this.userNotificationsEnabled, that.userNotificationsEnabled) && Objects.equals(this.userEmailingEnabled, that.userEmailingEnabled) && Objects.equals(this.localizedNames, that.localizedNames) && Objects.equals(this.name, that.name) && Objects.equals(this.options, that.options) && Objects.equals(this.startEmailTemplateId, that.startEmailTemplateId) && Objects.equals(this.modifyEmailTemplateId, that.modifyEmailTemplateId) && Objects.equals(this.cancelEmailTemplateId, that.cancelEmailTemplateId) && Objects.equals(this.endEmailTemplateId, that.endEmailTemplateId);
    }

    @JsonIgnore
    public UserActionOption getOption(String name) {
        if (name == null) {
            return null;
        }
        for (UserActionOption key : this.options) {
            if (!key.name.equals(name)) continue;
            return key;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.active, this.includeEmailInEventJSON, this.localizedNames, this.name, this.options, this.preventLogin, this.sendEndEvent, this.temporal, this.transactionType, this.userNotificationsEnabled, this.userEmailingEnabled, this.startEmailTemplateId, this.modifyEmailTemplateId, this.cancelEmailTemplateId, this.endEmailTemplateId});
    }

    public void normalize() {
        this.name = Normalizer.trim(this.name);
        if (this.localizedNames != null) {
            this.localizedNames.normalize();
        }
        if (this.options != null) {
            this.options.forEach(UserActionOption::normalize);
        }
    }

    public void sortOptions() {
        Collections.sort(this.options);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

