/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Application;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EmailConfiguration;
import io.fusionauth.domain.EventConfiguration;
import io.fusionauth.domain.ExternalIdentifierConfiguration;
import io.fusionauth.domain.FailedAuthenticationConfiguration;
import io.fusionauth.domain.FamilyConfiguration;
import io.fusionauth.domain.JWTConfiguration;
import io.fusionauth.domain.MaximumPasswordAge;
import io.fusionauth.domain.MinimumPasswordAge;
import io.fusionauth.domain.PasswordEncryptionConfiguration;
import io.fusionauth.domain.PasswordValidationRules;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.util.Normalizer;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class Tenant
implements Buildable<Tenant>,
_InternalJSONColumn {
    public final Map<String, Object> data = new LinkedHashMap<String, Object>();
    @InternalJSONColumn
    public boolean configured;
    @InternalJSONColumn
    public EmailConfiguration emailConfiguration = new EmailConfiguration();
    @InternalJSONColumn
    public EventConfiguration eventConfiguration = new EventConfiguration();
    @InternalJSONColumn
    public ExternalIdentifierConfiguration externalIdentifierConfiguration = new ExternalIdentifierConfiguration();
    @InternalJSONColumn
    public FailedAuthenticationConfiguration failedAuthenticationConfiguration = new FailedAuthenticationConfiguration();
    @InternalJSONColumn
    public FamilyConfiguration familyConfiguration = new FamilyConfiguration();
    @InternalJSONColumn
    public int httpSessionMaxInactiveInterval = 3600;
    public UUID id;
    @InternalJSONColumn
    public String issuer;
    @InternalJSONColumn
    public JWTConfiguration jwtConfiguration = new JWTConfiguration();
    @InternalJSONColumn
    public URI logoutURL;
    @InternalJSONColumn
    public MaximumPasswordAge maximumPasswordAge = new MaximumPasswordAge();
    @InternalJSONColumn
    public MinimumPasswordAge minimumPasswordAge = new MinimumPasswordAge();
    public String name;
    @InternalJSONColumn
    public PasswordEncryptionConfiguration passwordEncryptionConfiguration = new PasswordEncryptionConfiguration();
    @InternalJSONColumn
    public PasswordValidationRules passwordValidationRules = new PasswordValidationRules();
    public UUID themeId;

    public Tenant() {
    }

    public Tenant(UUID id, String name) {
        this.id = id;
        this.name = name;
    }

    public Tenant(Tenant other) {
        this.configured = other.configured;
        this.data.putAll(other.data);
        this.emailConfiguration = new EmailConfiguration(other.emailConfiguration);
        this.eventConfiguration = new EventConfiguration(other.eventConfiguration);
        this.externalIdentifierConfiguration = new ExternalIdentifierConfiguration(other.externalIdentifierConfiguration);
        this.failedAuthenticationConfiguration = new FailedAuthenticationConfiguration(other.failedAuthenticationConfiguration);
        this.familyConfiguration = new FamilyConfiguration(other.familyConfiguration);
        this.httpSessionMaxInactiveInterval = other.httpSessionMaxInactiveInterval;
        this.id = other.id;
        this.issuer = other.issuer;
        this.jwtConfiguration = new JWTConfiguration(other.jwtConfiguration);
        this.logoutURL = other.logoutURL;
        this.maximumPasswordAge = new MaximumPasswordAge(other.maximumPasswordAge);
        this.minimumPasswordAge = new MinimumPasswordAge(other.minimumPasswordAge);
        this.name = other.name;
        this.passwordEncryptionConfiguration = new PasswordEncryptionConfiguration(other.passwordEncryptionConfiguration);
        this.passwordValidationRules = new PasswordValidationRules(other.passwordValidationRules);
        this.themeId = other.themeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tenant)) {
            return false;
        }
        Tenant tenant = (Tenant)o;
        return this.configured == tenant.configured && this.httpSessionMaxInactiveInterval == tenant.httpSessionMaxInactiveInterval && Objects.equals(this.data, tenant.data) && Objects.equals(this.emailConfiguration, tenant.emailConfiguration) && Objects.equals(this.eventConfiguration, tenant.eventConfiguration) && Objects.equals(this.externalIdentifierConfiguration, tenant.externalIdentifierConfiguration) && Objects.equals(this.failedAuthenticationConfiguration, tenant.failedAuthenticationConfiguration) && Objects.equals(this.familyConfiguration, tenant.familyConfiguration) && Objects.equals(this.issuer, tenant.issuer) && Objects.equals(this.jwtConfiguration, tenant.jwtConfiguration) && Objects.equals(this.logoutURL, tenant.logoutURL) && Objects.equals(this.maximumPasswordAge, tenant.maximumPasswordAge) && Objects.equals(this.minimumPasswordAge, tenant.minimumPasswordAge) && Objects.equals(this.name, tenant.name) && Objects.equals(this.passwordEncryptionConfiguration, tenant.passwordEncryptionConfiguration) && Objects.equals(this.passwordValidationRules, tenant.passwordValidationRules) && Objects.equals(this.themeId, tenant.themeId);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.configured, this.emailConfiguration, this.eventConfiguration, this.externalIdentifierConfiguration, this.failedAuthenticationConfiguration, this.familyConfiguration, this.httpSessionMaxInactiveInterval, this.issuer, this.jwtConfiguration, this.logoutURL, this.maximumPasswordAge, this.minimumPasswordAge, this.name, this.passwordEncryptionConfiguration, this.passwordValidationRules, this.themeId);
    }

    @JsonIgnore
    public JWTConfiguration lookupJWTConfiguration(Application application) {
        if (application != null && application.jwtConfiguration != null && application.jwtConfiguration.enabled) {
            return application.jwtConfiguration;
        }
        return this.jwtConfiguration;
    }

    public void normalize() {
        if (!this.emailConfiguration.verifyEmail) {
            this.emailConfiguration.verifyEmailWhenChanged = false;
            this.emailConfiguration.verificationEmailTemplateId = null;
        }
        Normalizer.removeEmpty(this.data);
        this.name = Normalizer.trim(this.name);
        this.emailConfiguration.normalize();
    }

    public Tenant secure() {
        this.emailConfiguration.password = null;
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

