/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.OptBoolean;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.ContentStatus;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;

public class UserRegistration
implements Buildable<UserRegistration>,
_InternalJSONColumn {
    @JsonMerge(value=OptBoolean.FALSE)
    public final Map<String, Object> data;
    @InternalJSONColumn
    @JsonMerge(value=OptBoolean.FALSE)
    public final List<Locale> preferredLanguages = new ArrayList<Locale>();
    @InternalJSONColumn
    public final Map<String, String> tokens;
    public UUID applicationId;
    public String authenticationToken;
    public UUID cleanSpeakId;
    public UUID id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastLoginInstant;
    @JsonMerge(value=OptBoolean.FALSE)
    public SortedSet<String> roles = new TreeSet<String>();
    public ZoneId timezone;
    public String username;
    public ContentStatus usernameStatus;
    public boolean verified;

    public boolean hasRegistrationData() {
        return !this.data.isEmpty();
    }

    public UserRegistration() {
        this.data = new LinkedHashMap<String, Object>();
        this.tokens = new LinkedHashMap<String, String>();
    }

    public UserRegistration(Map<String, Object> mockData) {
        this.data = mockData;
        this.tokens = new LinkedHashMap<String, String>();
    }

    public UserRegistration(UserRegistration userRegistration) {
        this.applicationId = userRegistration.applicationId;
        this.authenticationToken = userRegistration.authenticationToken;
        this.cleanSpeakId = userRegistration.cleanSpeakId;
        this.id = userRegistration.id;
        this.insertInstant = userRegistration.insertInstant;
        this.lastLoginInstant = userRegistration.lastLoginInstant;
        this.preferredLanguages.addAll(userRegistration.preferredLanguages);
        this.roles.addAll(userRegistration.roles);
        this.timezone = userRegistration.timezone;
        this.username = userRegistration.username;
        this.usernameStatus = userRegistration.usernameStatus;
        this.verified = userRegistration.verified;
        this.data = new LinkedHashMap<String, Object>();
        if (userRegistration.data != null) {
            this.data.putAll(userRegistration.data);
        }
        this.tokens = new LinkedHashMap<String, String>();
        if (userRegistration.tokens != null) {
            this.tokens.putAll(userRegistration.tokens);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserRegistration)) {
            return false;
        }
        UserRegistration that = (UserRegistration)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.authenticationToken, that.authenticationToken) && Objects.equals(this.cleanSpeakId, that.cleanSpeakId) && Objects.equals(this.data, that.data) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastLoginInstant, that.lastLoginInstant) && Objects.equals(this.roles, that.roles) && Objects.equals(this.tokens, that.tokens) && Objects.equals(this.username, that.username) && Objects.equals((Object)this.usernameStatus, (Object)that.usernameStatus) && Objects.equals(this.verified, that.verified);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.applicationId, this.authenticationToken, this.cleanSpeakId, this.data, this.insertInstant, this.lastLoginInstant, this.roles, this.tokens, this.username, this.usernameStatus});
    }

    public void normalize() {
        this.authenticationToken = Normalizer.trimToNull(this.authenticationToken);
        this.preferredLanguages.removeIf(Objects::isNull);
        this.username = Normalizer.trim(this.username);
        Normalizer.removeEmpty(this.data);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

