/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.ContentStatus;
import io.fusionauth.domain.GroupMember;
import io.fusionauth.domain.SecureIdentity;
import io.fusionauth.domain.Tenantable;
import io.fusionauth.domain.TwoFactorDelivery;
import io.fusionauth.domain.UserRegistration;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.util.Normalizer;
import java.net.URI;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class User
extends SecureIdentity
implements Buildable<User>,
_InternalJSONColumn,
Tenantable {
    @InternalJSONColumn
    public final List<Locale> preferredLanguages = new ArrayList<Locale>();
    private final List<GroupMember> memberships = new ArrayList<GroupMember>();
    private final List<UserRegistration> registrations = new ArrayList<UserRegistration>();
    public boolean active;
    public LocalDate birthDate;
    public UUID cleanSpeakId;
    public Map<String, Object> data = new LinkedHashMap<String, Object>();
    public String email;
    public ZonedDateTime expiry;
    public String firstName;
    public String fullName;
    public URI imageUrl;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastLoginInstant;
    public String lastName;
    public String middleName;
    public String mobilePhone;
    public String parentEmail;
    public UUID tenantId;
    public ZoneId timezone;
    public TwoFactorDelivery twoFactorDelivery;
    public boolean twoFactorEnabled;
    public String twoFactorSecret;
    public String username;
    public ContentStatus usernameStatus;

    public User() {
    }

    public User(User user) {
        this.active = user.active;
        this.breachedPasswordLastCheckedInstant = user.breachedPasswordLastCheckedInstant;
        this.breachedPasswordStatus = user.breachedPasswordStatus;
        this.birthDate = user.birthDate;
        this.cleanSpeakId = user.cleanSpeakId;
        this.email = user.email;
        this.encryptionScheme = user.encryptionScheme;
        this.expiry = user.expiry;
        this.factor = user.factor;
        this.firstName = user.firstName;
        this.fullName = user.fullName;
        this.id = user.id;
        this.imageUrl = user.imageUrl;
        this.insertInstant = user.insertInstant;
        this.lastLoginInstant = user.lastLoginInstant;
        this.lastName = user.lastName;
        this.memberships.addAll(user.memberships.stream().map(GroupMember::new).collect(Collectors.toList()));
        this.middleName = user.middleName;
        this.mobilePhone = user.mobilePhone;
        this.parentEmail = user.parentEmail;
        this.password = user.password;
        this.passwordChangeReason = user.passwordChangeReason;
        this.passwordChangeRequired = user.passwordChangeRequired;
        this.passwordLastUpdateInstant = user.passwordLastUpdateInstant;
        this.preferredLanguages.addAll(user.preferredLanguages);
        this.registrations.addAll(user.registrations.stream().map(UserRegistration::new).collect(Collectors.toList()));
        this.salt = user.salt;
        this.tenantId = user.tenantId;
        this.timezone = user.timezone;
        this.twoFactorDelivery = user.twoFactorDelivery;
        this.twoFactorEnabled = user.twoFactorEnabled;
        this.twoFactorSecret = user.twoFactorSecret;
        this.username = user.username;
        this.usernameStatus = user.usernameStatus;
        this.verified = user.verified;
        if (user.data != null) {
            this.data.putAll(user.data);
        }
    }

    public void addMemberships(GroupMember member) {
        this.memberships.removeIf(m -> m.groupId.equals(member.groupId));
        this.memberships.add(member);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        this.sort();
        user.sort();
        return super.equals(o) && Objects.equals(this.active, user.active) && Objects.equals(this.birthDate, user.birthDate) && Objects.equals(this.cleanSpeakId, user.cleanSpeakId) && Objects.equals(this.data, user.data) && Objects.equals(this.email, user.email) && Objects.equals(this.expiry, user.expiry) && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.fullName, user.fullName) && Objects.equals(this.imageUrl, user.imageUrl) && Objects.equals(this.insertInstant, user.insertInstant) && Objects.equals(this.lastLoginInstant, user.lastLoginInstant) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.memberships, user.memberships) && Objects.equals(this.middleName, user.middleName) && Objects.equals(this.mobilePhone, user.mobilePhone) && Objects.equals(this.registrations, user.registrations) && Objects.equals(this.parentEmail, user.parentEmail) && Objects.equals(this.tenantId, user.tenantId) && Objects.equals(this.timezone, user.timezone) && Objects.equals((Object)this.twoFactorDelivery, (Object)user.twoFactorDelivery) && Objects.equals(this.twoFactorEnabled, user.twoFactorEnabled) && Objects.equals(this.twoFactorSecret, user.twoFactorSecret) && Objects.equals(this.username, user.username) && Objects.equals((Object)this.usernameStatus, (Object)user.usernameStatus);
    }

    @JsonIgnore
    public int getAge() {
        if (this.birthDate == null) {
            return -1;
        }
        return (int)this.birthDate.until(LocalDate.now(), ChronoUnit.YEARS);
    }

    @JsonIgnore
    public String getLogin() {
        return this.email == null ? this.username : this.email;
    }

    public List<GroupMember> getMemberships() {
        return this.memberships;
    }

    @JsonIgnore
    public String getName() {
        if (this.fullName != null) {
            return this.fullName;
        }
        if (this.firstName != null) {
            return this.firstName + (this.lastName != null ? " " + this.lastName : "");
        }
        return null;
    }

    public UserRegistration getRegistrationForApplication(UUID id) {
        return this.getRegistrations().stream().filter(reg -> reg.applicationId.equals(id)).findFirst().orElse(null);
    }

    public List<UserRegistration> getRegistrations() {
        return this.registrations;
    }

    public Set<String> getRoleNamesForApplication(UUID id) {
        UserRegistration registration = this.getRegistrationForApplication(id);
        return registration != null ? registration.roles : null;
    }

    @Override
    public UUID getTenantId() {
        return this.tenantId;
    }

    public boolean hasUserData() {
        if (!this.data.isEmpty()) {
            return true;
        }
        for (UserRegistration userRegistration : this.registrations) {
            if (!userRegistration.hasRegistrationData()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.active, this.birthDate, this.cleanSpeakId, this.data, this.email, this.expiry, this.firstName, this.fullName, this.imageUrl, this.insertInstant, this.lastLoginInstant, this.lastName, this.memberships, this.middleName, this.mobilePhone, this.registrations, this.parentEmail, this.tenantId, this.timezone, this.twoFactorDelivery, this.twoFactorEnabled, this.twoFactorSecret, this.username, this.usernameStatus});
    }

    public String lookupEmail() {
        if (this.email != null) {
            return this.email;
        }
        if (this.data.containsKey("email")) {
            return this.data.get("email").toString();
        }
        return null;
    }

    public Locale lookupPreferredLanguage(UUID applicationId) {
        for (UserRegistration registration : this.registrations) {
            if (!registration.applicationId.equals(applicationId) || registration.preferredLanguages.size() <= 0) continue;
            return registration.preferredLanguages.get(0);
        }
        if (this.preferredLanguages.size() > 0) {
            return this.preferredLanguages.get(0);
        }
        return null;
    }

    public void normalize() {
        Normalizer.removeEmpty(this.data);
        this.email = Normalizer.toLowerCase(Normalizer.trim(this.email));
        this.encryptionScheme = Normalizer.trim(this.encryptionScheme);
        this.firstName = Normalizer.trim(this.firstName);
        this.fullName = Normalizer.trim(this.fullName);
        this.lastName = Normalizer.trim(this.lastName);
        this.middleName = Normalizer.trim(this.middleName);
        this.mobilePhone = Normalizer.trim(this.mobilePhone);
        this.parentEmail = Normalizer.toLowerCase(Normalizer.trim(this.parentEmail));
        this.preferredLanguages.removeIf(Objects::isNull);
        this.username = Normalizer.trim(this.username);
        if (this.username != null && this.username.length() == 0) {
            this.username = null;
        }
        this.getRegistrations().forEach(UserRegistration::normalize);
    }

    public void removeMembershipById(UUID groupId) {
        this.memberships.removeIf(m -> m.groupId.equals(groupId));
    }

    public User secure() {
        this.encryptionScheme = null;
        this.factor = null;
        this.password = null;
        this.salt = null;
        this.twoFactorSecret = null;
        return this;
    }

    public User sort() {
        this.registrations.sort(Comparator.comparing(ur -> ur.applicationId));
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

