/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.LogHistory;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class UserActionLog
implements Buildable<UserActionLog> {
    public UUID actioneeUserId;
    public UUID actionerUserId;
    public List<UUID> applicationIds = new ArrayList<UUID>();
    public String comment;
    public ZonedDateTime createInstant;
    public boolean emailUserOnEnd;
    public Boolean endEventSent;
    public ZonedDateTime expiry;
    public LogHistory history;
    public UUID id;
    public String localizedName;
    public String localizedOption;
    public String localizedReason;
    public String name;
    public boolean notifyUserOnEnd;
    public String option;
    public String reason;
    public String reasonCode;
    public UUID userActionId;

    public UserActionLog() {
    }

    public UserActionLog(UUID actioneeUserId, UUID actionerUserId, UUID userActionId, List<UUID> applicationIds, String comment, ZonedDateTime expiry, String name, String localizedName, String option, String localizedOption, String reason, String localizedReason, String reasonCode, ZonedDateTime createInstant, Boolean endEventSent, LogHistory history, boolean notifyUserOnEnd, boolean emailUserOnEnd) {
        this.actioneeUserId = actioneeUserId;
        this.actionerUserId = actionerUserId;
        this.userActionId = userActionId;
        if (applicationIds != null) {
            this.applicationIds = applicationIds;
        }
        this.comment = comment;
        this.expiry = expiry;
        this.name = name;
        this.localizedName = localizedName;
        this.option = option;
        this.reason = reason;
        this.reasonCode = reasonCode;
        this.createInstant = createInstant;
        this.endEventSent = endEventSent;
        this.history = history;
        this.localizedOption = localizedOption;
        this.localizedReason = localizedReason;
        this.emailUserOnEnd = emailUserOnEnd;
        this.notifyUserOnEnd = notifyUserOnEnd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserActionLog)) {
            return false;
        }
        UserActionLog that = (UserActionLog)o;
        Collections.sort(this.applicationIds);
        Collections.sort(that.applicationIds);
        return Objects.equals(this.emailUserOnEnd, that.emailUserOnEnd) && Objects.equals(this.actioneeUserId, that.actioneeUserId) && Objects.equals(this.actionerUserId, that.actionerUserId) && Objects.equals(this.applicationIds, that.applicationIds) && Objects.equals(this.comment, that.comment) && Objects.equals(this.createInstant, that.createInstant) && Objects.equals(this.endEventSent, that.endEventSent) && Objects.equals(this.notifyUserOnEnd, that.notifyUserOnEnd) && Objects.equals(this.expiry, that.expiry) && Objects.equals(this.history, that.history) && Objects.equals(this.localizedName, that.localizedName) && Objects.equals(this.localizedOption, that.localizedOption) && Objects.equals(this.localizedReason, that.localizedReason) && Objects.equals(this.name, that.name) && Objects.equals(this.option, that.option) && Objects.equals(this.reason, that.reason) && Objects.equals(this.reasonCode, that.reasonCode) && Objects.equals(this.userActionId, that.userActionId);
    }

    public int hashCode() {
        return Objects.hash(this.actioneeUserId, this.actionerUserId, this.applicationIds, this.comment, this.createInstant, this.emailUserOnEnd, this.endEventSent, this.expiry, this.history, this.localizedName, this.localizedOption, this.localizedReason, this.name, this.option, this.reason, this.reasonCode, this.userActionId, this.notifyUserOnEnd);
    }

    @JsonIgnore
    public boolean isActive() {
        return this.expiry != null && this.expiry.isAfter(ZonedDateTime.now());
    }

    public void normalize() {
        this.comment = Normalizer.trim(this.comment);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

