/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum EventType {
    UserDelete("user.delete"),
    UserCreate("user.create"),
    UserUpdate("user.update"),
    UserDeactivate("user.deactivate"),
    UserBulkCreate("user.bulk.create"),
    UserReactivate("user.reactivate"),
    UserAction("user.action"),
    JWTRefreshTokenRevoke("jwt.refresh-token.revoke"),
    JWTPublicKeyUpdate("jwt.public-key.update"),
    UserLoginSuccess("user.login.success"),
    UserLoginFailed("user.login.failed"),
    UserRegistrationCreate("user.registration.create"),
    UserRegistrationUpdate("user.registration.update"),
    UserRegistrationDelete("user.registration.delete"),
    UserRegistrationVerified("user.registration.verified"),
    UserEmailVerified("user.email.verified"),
    UserPasswordBreach("user.password.breach"),
    Test("test");

    private static Map<String, EventType> nameMap;
    private final String eventName;

    private EventType(String eventName) {
        this.eventName = eventName;
    }

    public static List<EventType> allTypes() {
        return Arrays.asList(JWTPublicKeyUpdate, JWTRefreshTokenRevoke, UserLoginSuccess, UserLoginFailed, UserAction, UserBulkCreate, UserCreate, UserRegistrationCreate, UserRegistrationUpdate, UserRegistrationDelete, UserRegistrationVerified, UserDeactivate, UserDelete, UserReactivate, UserUpdate, UserEmailVerified, UserPasswordBreach);
    }

    public static List<EventType> allTypesForTransactionConfiguration() {
        return Arrays.asList(JWTPublicKeyUpdate, JWTRefreshTokenRevoke, UserLoginSuccess, UserLoginFailed, UserBulkCreate, UserCreate, UserRegistrationCreate, UserRegistrationUpdate, UserRegistrationDelete, UserRegistrationVerified, UserDeactivate, UserDelete, UserReactivate, UserUpdate, UserEmailVerified, UserPasswordBreach);
    }

    @JsonCreator
    public static EventType forValue(String value) {
        return nameMap.get(value);
    }

    @JsonValue
    public String eventName() {
        return this.eventName;
    }

    static {
        nameMap = new HashMap<String, EventType>(EventType.values().length);
        for (EventType eventType : EventType.values()) {
            nameMap.put(eventType.eventName(), eventType);
        }
    }
}

