/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.ExternalJWTIdentityProvider;
import io.fusionauth.domain.provider.FacebookIdentityProvider;
import io.fusionauth.domain.provider.GoogleIdentityProvider;
import io.fusionauth.domain.provider.HYPRIdentityProvider;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.provider.OpenIdConnectIdentityProvider;
import io.fusionauth.domain.provider.SAMLv2IdentityProvider;
import io.fusionauth.domain.provider.TwitterIdentityProvider;
import java.io.IOException;
import java.util.Arrays;

public class IdentityProviderJacksonHelper {
    public static IdentityProviderType extractType(DeserializationContext ctxt, JsonParser p, JsonNode idpNode) throws IOException {
        JsonNode node = idpNode.at("/type");
        String type = node.asText(IdentityProviderType.ExternalJWT.name());
        IdentityProviderType identityProviderType = IdentityProviderType.safeValueOf(type);
        if (identityProviderType == null) {
            return (IdentityProviderType)((Object)ctxt.handleUnexpectedToken(BaseIdentityProvider.class, node.asToken(), p, "Expected the type field to be one of " + String.join((CharSequence)",", Arrays.toString((Object[])IdentityProviderType.values()) + ", but found [" + node.asText() + "]"), new Object[0]));
        }
        return identityProviderType;
    }

    public static BaseIdentityProvider<?> newIdentityProvider(IdentityProviderType type) {
        switch (type) {
            case ExternalJWT: {
                return new ExternalJWTIdentityProvider();
            }
            case Facebook: {
                return new FacebookIdentityProvider();
            }
            case Google: {
                return new GoogleIdentityProvider();
            }
            case HYPR: {
                return new HYPRIdentityProvider();
            }
            case OpenIDConnect: {
                return new OpenIdConnectIdentityProvider();
            }
            case SAMLv2: {
                return new SAMLv2IdentityProvider();
            }
            case Twitter: {
                return new TwitterIdentityProvider();
            }
        }
        throw new IllegalStateException("Unexpected type [" + (Object)((Object)type) + "]. This is a FusionAuth bug, someone forgot to add a case statement for a new type.");
    }
}

