/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class OpenIdConfiguration
implements Buildable<OpenIdConfiguration> {
    public String authorization_endpoint = "%s/oauth2/authorize";
    public boolean backchannel_logout_supported = false;
    public List<String> claims_supported = new ArrayList<String>(Arrays.asList("applicationId", "aud", "authenticationType", "birthdate", "email", "email_verified", "exp", "family_name", "given_name", "iat", "iss", "middle_name", "name", "nbf", "phone_number", "picture", "preferred_username", "roles", "sub"));
    public String device_authorization_endpoint = "%s/oauth2/device_authorize";
    public String end_session_endpoint = "%s/oauth2/logout";
    public boolean frontchannel_logout_supported = true;
    public List<String> grant_types_supported = new ArrayList<String>(Arrays.asList("authorization_code", "password", "implicit", "refresh_token", "urn:ietf:params:oauth:grant-type:device_code"));
    public List<String> id_token_signing_alg_values_supported = new ArrayList<String>(Arrays.asList("ES256", "ES384", "ES512", "HS256", "HS384", "HS512", "RS256", "RS384", "RS512"));
    public String issuer;
    public String jwks_uri = "%s/.well-known/jwks.json";
    public List<String> response_modes_supported = new ArrayList<String>(Arrays.asList("form_post", "fragment", "query"));
    public List<String> response_types_supported = new ArrayList<String>(Arrays.asList("code", "id_token", "token id_token"));
    public List<String> scopes_supported = new ArrayList<String>(Arrays.asList("openid", "offline_access"));
    public List<String> subject_types_supported = new ArrayList<String>(Collections.singletonList("public"));
    public String token_endpoint = "%s/oauth2/token";
    public List<String> token_endpoint_auth_methods_supported = new ArrayList<String>(Arrays.asList("client_secret_basic", "client_secret_post", "none"));
    public String userinfo_endpoint = "%s/oauth2/userinfo";
    public List<String> userinfo_signing_alg_values_supported = new ArrayList<String>(Arrays.asList("ES256", "ES384", "ES512", "RS256", "RS384", "RS512", "HS256", "HS384", "HS512"));

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenIdConfiguration)) {
            return false;
        }
        OpenIdConfiguration that = (OpenIdConfiguration)o;
        return this.backchannel_logout_supported == that.backchannel_logout_supported && this.frontchannel_logout_supported == that.frontchannel_logout_supported && Objects.equals(this.authorization_endpoint, that.authorization_endpoint) && Objects.equals(this.claims_supported, that.claims_supported) && Objects.equals(this.device_authorization_endpoint, that.device_authorization_endpoint) && Objects.equals(this.end_session_endpoint, that.end_session_endpoint) && Objects.equals(this.grant_types_supported, that.grant_types_supported) && Objects.equals(this.id_token_signing_alg_values_supported, that.id_token_signing_alg_values_supported) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.jwks_uri, that.jwks_uri) && Objects.equals(this.response_modes_supported, that.response_modes_supported) && Objects.equals(this.response_types_supported, that.response_types_supported) && Objects.equals(this.scopes_supported, that.scopes_supported) && Objects.equals(this.subject_types_supported, that.subject_types_supported) && Objects.equals(this.token_endpoint, that.token_endpoint) && Objects.equals(this.token_endpoint_auth_methods_supported, that.token_endpoint_auth_methods_supported) && Objects.equals(this.userinfo_endpoint, that.userinfo_endpoint) && Objects.equals(this.userinfo_signing_alg_values_supported, that.userinfo_signing_alg_values_supported);
    }

    public int hashCode() {
        return Objects.hash(this.authorization_endpoint, this.backchannel_logout_supported, this.claims_supported, this.device_authorization_endpoint, this.end_session_endpoint, this.frontchannel_logout_supported, this.grant_types_supported, this.id_token_signing_alg_values_supported, this.issuer, this.jwks_uri, this.response_modes_supported, this.response_types_supported, this.scopes_supported, this.subject_types_supported, this.token_endpoint, this.token_endpoint_auth_methods_supported, this.userinfo_endpoint, this.userinfo_signing_alg_values_supported);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

