/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.User;
import io.fusionauth.domain.event.BaseEvent;
import io.fusionauth.domain.event.EventType;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import java.util.Objects;
import java.util.UUID;

public class UserLoginSuccessEvent
extends BaseEvent
implements Buildable<UserLoginSuccessEvent> {
    public UUID applicationId;
    public String authenticationType;
    public UUID identityProviderId;
    public String identityProviderName;
    public User user;

    @JacksonConstructor
    public UserLoginSuccessEvent() {
    }

    public UserLoginSuccessEvent(UUID applicationId, String authenticationType, BaseIdentityProvider<?> identityProvider, User user) {
        this.applicationId = applicationId;
        this.authenticationType = authenticationType;
        this.identityProviderId = identityProvider.id;
        this.identityProviderName = identityProvider.name;
        this.user = user;
    }

    public UserLoginSuccessEvent(UUID applicationId, String authenticationType, User user) {
        this.applicationId = applicationId;
        this.authenticationType = authenticationType;
        this.user = user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserLoginSuccessEvent that = (UserLoginSuccessEvent)o;
        return super.equals(o) && Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.authenticationType, that.authenticationType) && Objects.equals(this.identityProviderId, that.identityProviderId) && Objects.equals(this.identityProviderName, that.identityProviderName) && Objects.equals(this.user, that.user);
    }

    @Override
    public EventType getType() {
        return EventType.UserLoginSuccess;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationId, this.authenticationType, this.identityProviderId, this.identityProviderName, this.user);
    }

    @Override
    public String toString() {
        return ToString.toString((Object)this);
    }
}

