/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.provider.BaseIdentityProviderApplicationConfiguration;
import io.fusionauth.domain.provider.IdentityProviderType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;

@JsonIgnoreProperties(value={"type"}, allowGetters=true, allowSetters=false)
public abstract class BaseIdentityProvider<D extends BaseIdentityProviderApplicationConfiguration>
extends Enableable
implements _InternalJSONColumn {
    public final Map<String, Object> data = new HashMap<String, Object>();
    public Map<UUID, D> applicationConfiguration = new HashMap<UUID, D>();
    @InternalJSONColumn
    public boolean debug;
    public UUID id;
    public LambdaConfiguration lambdaConfiguration = new LambdaConfiguration();
    public String name;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseIdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseIdentityProvider that = (BaseIdentityProvider)o;
        return Objects.equals(this.applicationConfiguration, that.applicationConfiguration) && Objects.equals(this.data, that.data) && Objects.equals(this.debug, that.debug) && Objects.equals(this.lambdaConfiguration, that.lambdaConfiguration) && Objects.equals(this.name, that.name) && Objects.equals((Object)this.getType(), (Object)that.getType());
    }

    public abstract IdentityProviderType getType();

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.applicationConfiguration, this.data, this.debug, this.lambdaConfiguration, this.name, this.getType()});
    }

    @JsonIgnore
    public boolean inUse() {
        return this.enabled && this.applicationConfiguration.values().stream().anyMatch(c -> c.enabled);
    }

    public boolean isEnabledForApplicationId(UUID applicationId) {
        BaseIdentityProviderApplicationConfiguration configuration = (BaseIdentityProviderApplicationConfiguration)this.applicationConfiguration.get(applicationId);
        return configuration != null && configuration.enabled;
    }

    public void normalize() {
    }

    public BaseIdentityProvider<D> secure() {
        return this;
    }

    protected <R> R app(UUID applicationId, Function<D, R> app) {
        BaseIdentityProviderApplicationConfiguration config = (BaseIdentityProviderApplicationConfiguration)this.applicationConfiguration.get(applicationId);
        return config == null ? null : (R)app.apply(config);
    }

    protected <R> R app(String clientId, Function<D, R> app) {
        return this.app(this.parseUUID(clientId), app);
    }

    protected <R> R lookup(Supplier<R> global, Supplier<R> app) {
        R v = app.get();
        return v != null ? v : global.get();
    }

    protected UUID parseUUID(String clientId) {
        try {
            return UUID.fromString(clientId);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    public static class LambdaConfiguration {
        public UUID reconcileId;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LambdaConfiguration)) {
                return false;
            }
            LambdaConfiguration that = (LambdaConfiguration)o;
            return Objects.equals(this.reconcileId, that.reconcileId);
        }

        public int hashCode() {
            return Objects.hash(this.reconcileId);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

