/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.util;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Normalizer {
    public static String lineReturns(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\r\\n|\\r", "\n");
    }

    public static <T> void lineReturnsMap(Map<T, String> map) {
        map.forEach((key, value) -> {
            if (value != null) {
                map.put(key, value.replaceAll("\\r\\n|\\r", "\n"));
            }
        });
    }

    public static <T> void removeEmpty(List<T> list) {
        list.removeIf(Objects::isNull);
    }

    public static <T, U> void removeEmpty(Map<T, U> map) {
        if (map == null) {
            return;
        }
        map.keySet().removeIf(key -> map.get(key) == null);
    }

    public static String removeLineReturns(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\r\\n|\\r|\\n", "");
    }

    public static String toLowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String trim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim();
    }

    public static <T> void trimMap(Map<T, String> map) {
        map.forEach((key, value) -> {
            if (value != null) {
                map.put(key, value.trim());
            }
        });
    }

    public static String trimToNull(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        return str;
    }

    public static ZonedDateTime truncateToMilliseconds(ZonedDateTime time) {
        if (time == null) {
            return null;
        }
        return time.truncatedTo(ChronoUnit.MILLIS);
    }
}

