/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;

public class ApplicationRole
implements Comparable<ApplicationRole>,
Buildable<ApplicationRole> {
    @JsonIgnore
    public UUID applicationId;
    public String description;
    public UUID id;
    public ZonedDateTime insertInstant;
    public boolean isDefault;
    public boolean isSuperRole;
    public ZonedDateTime lastUpdateInstant;
    public String name;

    public ApplicationRole() {
    }

    public ApplicationRole(String roleName) {
        this(null, null, roleName, false, false, null);
    }

    public ApplicationRole(UUID id, UUID applicationId, String roleName, boolean isDefault, boolean isSuperRole, String description) {
        this.id = id;
        this.applicationId = applicationId;
        this.name = roleName;
        this.isDefault = isDefault;
        this.isSuperRole = isSuperRole;
        this.description = description;
    }

    @Override
    public int compareTo(ApplicationRole o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationRole)) {
            return false;
        }
        ApplicationRole that = (ApplicationRole)o;
        return this.isDefault == that.isDefault && this.isSuperRole == that.isSuperRole && Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.id, that.id) && Objects.equals(this.description, that.description) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && Objects.equals(this.name, that.name);
    }

    @JsonIgnore
    public String getDisplay() {
        return this.description != null ? this.description + " (" + this.name + ")" : this.name;
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.description, this.id, this.insertInstant, this.isDefault, this.isSuperRole, this.lastUpdateInstant, this.name);
    }

    public void normalize() {
        this.description = Normalizer.trim(this.description);
        this.name = Normalizer.trim(this.name);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

